/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.DayPart;
import ordermate.database.queries.hardware.CashDrawerQueries;
import ordermate.database.reports.reconciliation.ShiftReconciliationSearcher;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportColumns;
import ordermate.database.reports.sata.SATAReportProperties;

public class ReconciliationByTypeCompiler
extends AbstractSATACompiler {
    private ShiftReconciliationSearcher searcher = new ShiftReconciliationSearcher();
    private boolean totalEftposPerCD;
    private List<FinanceUnit> eftAndWebUnits;
    private List<CashDrawer> allActiveCDs;

    ReconciliationByTypeCompiler() {
    }

    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        this.totalEftposPerCD = SATAReportProperties.isTotalEftposPerCashdrawer();
        this.searcher.getTradingDayFilter().setStart(this.getFrom());
        this.searcher.getTradingDayFilter().setEnd(this.getTo());
        List recs = this.searcher.search();
        this.allActiveCDs = CashDrawerQueries.getAllCashdrawers();
        this.eftAndWebUnits = new ArrayList<FinanceUnit>();
        if (this.totalEftposPerCD && this.allActiveCDs != null) {
            for (CashDrawer cd : this.allActiveCDs) {
                this.preload(reportMap.values(), SATAReportColumns.EFTPOS_PREFIX.getName() + cd.getLabel());
            }
        }
        this.preload(reportMap.values(), SATAReportColumns.CASH.getName());
        this.initPayments(this.totalEftposPerCD, this.eftAndWebUnits, reportMap);
        this.preload(reportMap.values(), SATAReportColumns.OTHER.getName());
        DayPart lastPart = null;
        if (this.groupByDayParts) {
            lastPart = DayPart.getAllDayPartsCached().get(DayPart.getAllDayPartsCached().size() - 1);
        }
        for (ShiftReconciliation rec : recs) {
            this.addShiftReconciliation(rec, reportMap.get(SATAReport.createId(rec.getShift().getTradingDay(), lastPart)));
        }
    }

    private void preload(Collection<SATAReport> reports, String name) {
        for (SATAReport report : reports) {
            report.getFinancePayments().add(new Pair<String, Price>(name, Price.ZERO_NO_ROUND));
        }
    }

    private void addShiftReconciliation(ShiftReconciliation rec, SATAReport report) {
        int index = 0;
        int offset = 0;
        boolean includePettyCashInOther = SATAReportProperties.isOtherInclPettyCash();
        if (this.totalEftposPerCD) {
            if (this.allActiveCDs != null) {
                block0: for (CashDrawer cd : this.allActiveCDs) {
                    for (int i = 0; i < rec.getCashDrawerReconciliations().size(); ++i) {
                        CashdrawerReconciliation cdRec = rec.getCashDrawerReconciliations().get(i);
                        if (!cdRec.getCashDrawer().equals(cd)) continue;
                        int idx = this.allActiveCDs.indexOf(cd);
                        for (FinanceUnit.EftposUnitType unit : FinanceUnit.EftposUnitType.values()) {
                            this.add(report.getFinancePayments().get(idx), cdRec.getCreditEntry(FinanceUnit.getUnitForName(unit.getUnitName())).getValue());
                        }
                        continue block0;
                    }
                }
            }
            offset = this.allActiveCDs != null ? this.allActiveCDs.size() : 0;
        }
        for (CashdrawerReconciliation cdRec : rec.getCashDrawerReconciliations()) {
            index = offset;
            this.add(report.getFinancePayments().get(index), cdRec.getTotalCashLessFloat());
            ++index;
            for (FinanceUnit nextUnit : this.eftAndWebUnits) {
                if (FinanceUnit.WEB_TYPE.toString().equals(nextUnit.getType().toString())) {
                    this.add(report.getFinancePayments().get(index), cdRec.getWebEntry(nextUnit).getValue());
                } else {
                    this.add(report.getFinancePayments().get(index), cdRec.getCreditEntry(nextUnit).getValue());
                }
                ++index;
            }
            this.add(report.getFinancePayments().get(index), cdRec.getCashOutEntry().getValue());
            this.add(report.getFinancePayments().get(index), cdRec.getTipsTotal());
            this.add(report.getFinancePayments().get(index), cdRec.getFloatEntry().getValue());
            if (includePettyCashInOther) {
                this.add(report.getFinancePayments().get(index), cdRec.getPettyCashTotal());
                continue;
            }
            report.addPettyCash(cdRec.getPettyCashTotal());
        }
    }

    private void add(Pair<String, Price> pair, Price valueToAdd) {
        if (valueToAdd.doubleValue() != 0.0) {
            pair.value = ((Price)pair.value).add(valueToAdd);
        }
    }
}

