/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sata.SATAReportProperties;

public class SATAReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private TradingDay tradingDay;
    private DayPart dayPart;
    private List<Pair<InventoryCategory, Price>> catSales = new ArrayList<Pair<InventoryCategory, Price>>();
    private Price discounts = Price.ZERO_NO_ROUND;
    private Price surcharges = Price.ZERO_NO_ROUND;
    private Price categoriesTotal = Price.ZERO_NO_ROUND;
    private Price net = Price.ZERO_NO_ROUND;
    private Price taxFreeSales = Price.ZERO_NO_ROUND;
    private Price totalTax = Price.ZERO_NO_ROUND;
    private List<Pair<TaxCode, Price>> taxes = new ArrayList<Pair<TaxCode, Price>>();
    private Price gross = Price.ZERO_NO_ROUND;
    private Price tips = Price.ZERO_NO_ROUND;
    private List<Pair<String, Price>> financePayments = new ArrayList<Pair<String, Price>>();
    private Price debtors = Price.ZERO_NO_ROUND;
    private Price debtorPayments = Price.ZERO_NO_ROUND;
    private Price debtorSales = Price.ZERO_NO_ROUND;
    private Price totalVoucherTopup = Price.ZERO_NO_ROUND;
    private Price totalVoucherTopupReversal = Price.ZERO_NO_ROUND;
    private Price systemTakings = Price.ZERO_NO_ROUND;
    private Price actualTakings = Price.ZERO_NO_ROUND;
    private Price variance = Price.ZERO_NO_ROUND;
    private Price totalVoucherRedeem = Price.ZERO_NO_ROUND;
    private Price totalVoucherRedeemReversal = Price.ZERO_NO_ROUND;
    private Price pettyCash = Price.ZERO_NO_ROUND;
    private Integer covers = 0;

    public SATAReport(TradingDay yourDay, DayPart dayPart) {
        this.tradingDay = yourDay;
        this.setDayPart(dayPart);
        this.setID(SATAReport.createId(this.tradingDay, dayPart));
    }

    public static Long createId(TradingDay td, DayPart part) {
        if (part != null) {
            return MathsUtils.cantorPair(td.getID().intValue(), part.getID().intValue());
        }
        return td.getID();
    }

    public TradingDay getTradingDay() {
        return this.tradingDay;
    }

    public Date getDate() {
        return this.tradingDay.getDate();
    }

    public DayPart getDayPart() {
        return this.dayPart;
    }

    public void setDayPart(DayPart part) {
        this.dayPart = part;
    }

    public List<Pair<InventoryCategory, Price>> getCatSales() {
        return this.catSales;
    }

    public Price getDiscounts() {
        return this.discounts;
    }

    public Price getSurcharges() {
        return this.surcharges;
    }

    public Price getTaxFreeSales() {
        return this.taxFreeSales;
    }

    public Price getTotalTax() {
        return this.totalTax;
    }

    public List<Pair<TaxCode, Price>> getTaxes() {
        return this.taxes;
    }

    protected void setTaxes(List<Pair<TaxCode, Price>> value) {
        this.taxes = value;
    }

    public Price getNet() {
        return this.net;
    }

    public Price getGross() {
        return this.gross;
    }

    public Price getTips() {
        return this.tips;
    }

    public void setTips(Price value) {
        this.tips = value;
    }

    public Price getCategoriesTotal() {
        return this.categoriesTotal;
    }

    public List<Pair<String, Price>> getFinancePayments() {
        return this.financePayments;
    }

    public Price getDebtors() {
        if (this.getDebtorSales() != null && this.getDebtorPayments() != null) {
            return this.getDebtorSales().subtract(this.getDebtorPayments());
        }
        return this.debtors;
    }

    public Price getDebtorSales() {
        return this.debtorSales;
    }

    public Price getDebtorPayments() {
        return this.debtorPayments;
    }

    public Integer getCovers() {
        return this.covers;
    }

    public Price getSystemTakings() {
        return this.systemTakings;
    }

    public Price getActualTakings() {
        return this.actualTakings;
    }

    public Price getVariance() {
        return this.variance;
    }

    public void setCatSales(List<Pair<InventoryCategory, Price>> grossSales) {
        this.catSales = grossSales;
    }

    public void setDiscounts(Price discounts) {
        this.discounts = discounts;
    }

    public void setSurcharges(Price value) {
        this.surcharges = value;
    }

    public void setTaxFreeSales(Price value) {
        this.taxFreeSales = value;
    }

    public void setFinanceSales(List<Pair<String, Price>> financeSales) {
        this.financePayments = financeSales;
    }

    public void setDebtorSales(Price sales) {
        this.debtorSales = sales;
    }

    public void setDebtorPayments(Price payments) {
        this.debtorPayments = payments;
    }

    public void setCovers(Integer patrons) {
        this.covers = patrons;
    }

    public void setSystemTakings(Price systemTakings) {
        this.systemTakings = systemTakings;
    }

    public void setActualTakings(Price actualTakings) {
        this.actualTakings = actualTakings;
    }

    public void addGrossSales(Price nextGross) {
        this.gross = this.gross.add(nextGross);
    }

    private void processAdjustments() {
        Price taxFactor;
        boolean adjustmentsIncTax = SATAReportProperties.isAdjustmentInclTax();
        if (!(adjustmentsIncTax || this.totalTax.isZero() || (taxFactor = this.gross.divide(this.totalTax)).isZero())) {
            this.setDiscounts(this.discounts.subtract(this.discounts.divide(taxFactor)));
            this.setSurcharges(this.surcharges.subtract(this.surcharges.divide(taxFactor)));
        }
    }

    private void processNet() {
        boolean netIncTax = SATAReportProperties.isNetSalesInclTax();
        this.net = !netIncTax ? this.gross.subtract(this.totalTax) : this.gross;
    }

    public void finalise() {
        if (this.getActualTakings() != null) {
            if (SATAReportProperties.isVarianceBetweenSalesAndTakings()) {
                Price debtorsBalance = this.getDebtorPayments().subtract(this.getDebtorSales());
                Price price = this.getTotalVoucherTopup().add(this.getTotalVoucherTopupReversal()).subtract(this.getTotalVoucherRedeem().subtract(this.getTotalVoucherRedeemReversal()));
                this.variance = this.getGross().subtract(this.getActualTakings().add(debtorsBalance).add(price));
            } else {
                this.variance = this.getActualTakings().subtract(this.getSystemTakings()).add(this.getTotalVoucherTopup().add(this.getTotalVoucherTopupReversal()));
            }
        }
        this.categoriesTotal = Price.ZERO_NO_ROUND;
        for (Pair<InventoryCategory, Price> pair : this.catSales) {
            this.categoriesTotal = this.categoriesTotal.add(pair.getValue());
        }
        this.totalTax = Price.ZERO_NO_ROUND;
        for (Pair<PersistentObject, Price> pair : this.taxes) {
            this.totalTax = this.totalTax.add(pair.getValue());
        }
        this.processAdjustments();
        this.processNet();
    }

    public void addVoucherRedeem(Price amount) {
        this.totalVoucherRedeem = this.totalVoucherRedeem.add(amount);
    }

    public Price getTotalVoucherRedeem() {
        return this.totalVoucherRedeem;
    }

    public void addVoucherRedeemReversal(Price amount) {
        this.totalVoucherRedeemReversal = this.totalVoucherRedeemReversal.add(amount);
    }

    public Price getTotalVoucherRedeemReversal() {
        return this.totalVoucherRedeemReversal;
    }

    public void addVoucherTopup(Price amount) {
        this.totalVoucherTopup = this.totalVoucherTopup.add(amount);
    }

    public Price getTotalVoucherTopup() {
        return this.totalVoucherTopup;
    }

    public void addVoucherTopupReversal(Price amount) {
        this.totalVoucherTopupReversal = this.totalVoucherTopupReversal.add(amount);
    }

    public Price getTotalVoucherTopupReversal() {
        return this.totalVoucherTopupReversal;
    }

    public Price getPettyCash() {
        return this.pettyCash;
    }

    public void addPettyCash(Price pCash) {
        this.pettyCash = this.pettyCash.add(pCash);
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PersistentObject.DerivedProperty<Date> DATE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SATAReport.class), "date");
        public PropertiedObject.Property<DayPart> DAY_PART;
        public PropertiedObject.Property<List<Pair<InventoryCategory, Price>>> CAT_SALES;
        public PropertiedObject.Property<Price> DISCOUNTS;
        public PropertiedObject.Property<Price> SURCHARGES;
        public PropertiedObject.Property<Price> CATEGORIES_TOTAL;
        public PropertiedObject.Property<Price> NET;
        public PropertiedObject.Property<Price> TAX_FREE_SALES;
        public PropertiedObject.Property<List<Pair<TaxCode, Price>>> TAXES;
        public PropertiedObject.Property<Price> TOTAL_TAX;
        public PropertiedObject.Property<Price> GROSS;
        public PropertiedObject.Property<List<Pair<FinanceUnit, Price>>> FINANCE_PAYMENTS;
        public PropertiedObject.Property<Price> TIPS;
        public PropertiedObject.Property<Price> DEBTORS;
        public PropertiedObject.Property<Price> DEBTOR_PAYMENTS;
        public PropertiedObject.Property<Price> DEBTOR_SALES;
        public PropertiedObject.Property<Price> TOTAL_VOUCHER_TOPUP;
        public PropertiedObject.Property<Price> TOTAL_VOUCHER_TOPUP_REVERSAL;
        public PropertiedObject.Property<Price> SYSTEM_TAKINGS;
        public PropertiedObject.Property<Price> ACTUAL_TAKINGS;
        public PropertiedObject.Property<Price> VARIANCE;
        public PropertiedObject.Property<Price> TOTAL_VOUCHER_REDEEM;
        public PropertiedObject.Property<Price> TOTAL_VOUCHER_REDEEM_REVERSAL;
        public PropertiedObject.Property<Integer> COVERS;
    }
}

