/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.AdjustmentsReportCompiler;
import ordermate.database.reports.sata.CoversCompiler;
import ordermate.database.reports.sata.DebtorCompiler;
import ordermate.database.reports.sata.GiftVoucherSalesCompiler;
import ordermate.database.reports.sata.GrossSalesCompiler;
import ordermate.database.reports.sata.PaymentByTypeCompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportColumns;
import ordermate.database.reports.sata.SATAReportCompiler;
import ordermate.database.reports.sata.SATAReportProperties;
import ordermate.database.reports.sata.SalesByCategoryCompiler;
import ordermate.database.reports.sata.TakingsCompiler;
import ordermate.database.reports.sata.TaxByTypeCompiler;
import ordermate.database.sales.SalesItemQuantity;

public class SATAReportBySIQCompiler
extends SATAReportCompiler {
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private boolean groupByDayParts = DayPart.isDayPartsDefined();

    public static SATAReportBySIQCompiler getMonthCompiler(Date aDate) {
        Date endDate = DateTimeUtils.getEndOfMonth(aDate).getTime();
        Calendar cal = DateTimeUtils.toCal(aDate);
        cal.set(5, 1);
        Date startDate = DateTimeUtils.getStartOfDay(cal.getTime());
        return new SATAReportBySIQCompiler(startDate, endDate);
    }

    public SATAReportBySIQCompiler(Date startDate, Date endDate) {
        super(startDate, endDate);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
    }

    public boolean isGroupByDayParts() {
        return this.groupByDayParts;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true)
    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @Override
    public List<SATAReport> performReport() {
        return super.performReport();
    }

    @Override
    protected void addCompilers(List<AbstractSATACompiler> compilers) {
        compilers.add(new SalesByCategoryCompiler());
        compilers.add(new GrossSalesCompiler());
        compilers.add(new AdjustmentsReportCompiler());
        compilers.add(new TaxByTypeCompiler());
        compilers.add(new PaymentByTypeCompiler());
        compilers.add(new DebtorCompiler());
        compilers.add(new TakingsCompiler());
        compilers.add(new GiftVoucherSalesCompiler());
        if (!SATAReportProperties.getHiddenColumns().contains(SATAReportColumns.COVERS.getName())) {
            compilers.add(new CoversCompiler());
        }
    }

    @Override
    protected void modifyCompiler(AbstractSATACompiler compiler) {
        compiler.siqTradingDay = true;
        compiler.groupByDayParts = this.groupByDayParts;
        compiler.salesLocations = this.salesLocationFilter.getSelectedOptions();
        super.modifyCompiler(compiler);
    }

    @Override
    public boolean canUseReconciliation() {
        return false;
    }

    @Override
    public String getTitle() {
        return "Sales and Takings Rundown ";
    }

    @Override
    public String getSubTitle() {
        StringBuilder SB = new StringBuilder();
        if (this.groupByDayParts) {
            SB.append("By day parts ");
        }
        if (this.salesLocationFilter.hasSearchValue()) {
            SB.append("Sales Locations: ").append(this.salesLocationFilter.getSelectedOptions());
        }
        return SB.toString();
    }
}

