/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.AdjustmentsReportCompiler;
import ordermate.database.reports.sata.CoversCompiler;
import ordermate.database.reports.sata.DebtorCompiler;
import ordermate.database.reports.sata.FirstSATACompiler;
import ordermate.database.reports.sata.GiftVoucherSalesCompiler;
import ordermate.database.reports.sata.GrossSalesCompiler;
import ordermate.database.reports.sata.LastSATACompiler;
import ordermate.database.reports.sata.PaymentByTypeCompiler;
import ordermate.database.reports.sata.ReconciliationByTypeCompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportColumns;
import ordermate.database.reports.sata.SATAReportProperties;
import ordermate.database.reports.sata.SalesByCategoryCompiler;
import ordermate.database.reports.sata.TakingsCompiler;
import ordermate.database.reports.sata.TaxByTypeCompiler;

public class SATAReportCompiler {
    private List<SATAReport> cachedResults;
    protected DateRangeSearchFilter dateFilter = new OptimisedDateRangeSearchFilter(null, SQLDateType.TIMESTAMP);
    private List<AbstractSATACompiler> compilers;

    public static SATAReportCompiler getMonthCompiler(Date aDate) {
        Date endDate = DateTimeUtils.getEndOfMonth(aDate).getTime();
        Calendar cal = DateTimeUtils.toCal(aDate);
        cal.set(5, 1);
        Date startDate = DateTimeUtils.getStartOfDay(cal.getTime());
        return new SATAReportCompiler(startDate, endDate);
    }

    public SATAReportCompiler(Date fromThisDate, Date toThisDate) {
        this.setDateRange(fromThisDate, toThisDate);
        this.compilers = new ArrayList<AbstractSATACompiler>();
        this.compilers.add(new FirstSATACompiler());
        this.addCompilers(this.compilers);
        this.compilers.add(new LastSATACompiler());
    }

    protected void addCompilers(List<AbstractSATACompiler> compilersList) {
        compilersList.add(new SalesByCategoryCompiler());
        compilersList.add(new GrossSalesCompiler());
        compilersList.add(new AdjustmentsReportCompiler());
        compilersList.add(new TaxByTypeCompiler());
        compilersList.add(new PaymentByTypeCompiler());
        compilersList.add(new ReconciliationByTypeCompiler());
        compilersList.add(new DebtorCompiler());
        compilersList.add(new GiftVoucherSalesCompiler());
        compilersList.add(new TakingsCompiler());
        if (!SATAReportProperties.getHiddenColumns().contains(SATAReportColumns.COVERS.getName())) {
            compilersList.add(new CoversCompiler());
        }
    }

    public Date getFrom() {
        return (Date)this.dateFilter.getStart();
    }

    public Date getTo() {
        return (Date)this.dateFilter.getEnd();
    }

    public void setDateRange(Date fromThisDate, Date toThisDate) {
        this.dateFilter.setStart(fromThisDate);
        this.dateFilter.setEnd(toThisDate);
    }

    @FilterConfig(name="Date Range", dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, dateType=SQLDateType.DATE, priority=true, sequence=1)
    public DateRangeSearchFilter getDateFilter() {
        return this.dateFilter;
    }

    public List<SATAReport> performReport() {
        if (this.dateFilter.getStart() == null || this.dateFilter.getEnd() == null) {
            OrderMate.LOG.warn("Cannot perform SATA report if date boundaries are not set");
            return Collections.emptyList();
        }
        List<AbstractSATACompiler> localCompilers = this.filterCompilers();
        LinkedHashMap<Long, SATAReport> reportMap = new LinkedHashMap<Long, SATAReport>();
        for (AbstractSATACompiler compiler : localCompilers) {
            this.modifyCompiler(compiler);
            compiler.populateMap(reportMap);
        }
        ArrayList<SATAReport> reports = new ArrayList<SATAReport>(reportMap.values());
        this.cachedResults = reports;
        return reports;
    }

    protected void modifyCompiler(AbstractSATACompiler compiler) {
        compiler.setDays(this.getFrom(), this.getTo());
    }

    private List<AbstractSATACompiler> filterCompilers() {
        ArrayList<AbstractSATACompiler> localCompilers = new ArrayList<AbstractSATACompiler>();
        boolean useSystemPayments = this.canUseReconciliation() && SATAReportProperties.isUseSystemPayments();
        for (AbstractSATACompiler compiler : this.compilers) {
            if (compiler instanceof PaymentByTypeCompiler) {
                if (!useSystemPayments) continue;
                localCompilers.add(compiler);
                continue;
            }
            if (compiler instanceof ReconciliationByTypeCompiler) {
                if (useSystemPayments) continue;
                localCompilers.add(compiler);
                continue;
            }
            localCompilers.add(compiler);
        }
        return localCompilers;
    }

    public List<SATAReport> getCachedResults() {
        return this.cachedResults;
    }

    public boolean canUseReconciliation() {
        return true;
    }

    public void clearCache() {
        this.cachedResults = null;
    }

    public String getTitle() {
        return "Sales and Takings Analysis ";
    }

    public String getSubTitle() {
        return null;
    }
}

