/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;

public class SATAReportProperties {
    public static final String USE_SYSTEM_PAYMENTS = "Use System Payments";
    public static final String HIDDEN_COLUMNS = "Hidden Columns";
    public static final String CATEGORY_SALES_INC_TAX = "Category Sales Inc Tax";
    public static final String CATEGORY_SALES_AFTER_ADJUSTMENTS = "Category Sales After Adjustments";
    public static final String ADJUSTMENTS_INC_TAX = "Adjustments Inc Tax";
    public static final String NET_SALES_INC_TAX = "Net Sales Inc Tax";
    public static final String OTHER_INC_PETTY_CASH = "Other Inc Petty Cash";
    public static final String VARIANCE_BETWEEN_SALES_AND_TAKINGS = "Variance Between Sales And Takings";
    public static final String TOTAL_EFTPOS_PER_CASHDRAWER = "Total EFTPOS Per Cashdrawer";
    public static final String NET_SALES_INC_ADJUSTMENTS = "Net Sales Inc Adjustments";

    public static boolean isCatSalesInclTax() {
        return ReportProperty.find(ReportGroup.SATA, CATEGORY_SALES_INC_TAX).getBooleanValue(Boolean.FALSE);
    }

    public static boolean isCatSalesAfterAdjustments() {
        return ReportProperty.find(ReportGroup.SATA, CATEGORY_SALES_AFTER_ADJUSTMENTS).getBooleanValue(Boolean.FALSE);
    }

    public static boolean isAdjustmentInclTax() {
        return ReportProperty.find(ReportGroup.SATA, ADJUSTMENTS_INC_TAX).getBooleanValue(Boolean.FALSE);
    }

    public static boolean isNetSalesInclTax() {
        return ReportProperty.find(ReportGroup.SATA, NET_SALES_INC_TAX).getBooleanValue(Boolean.FALSE);
    }

    @Deprecated
    public static boolean isNetSalesInclAdjustments() {
        return ReportProperty.find(ReportGroup.SATA, NET_SALES_INC_ADJUSTMENTS).getBooleanValue(Boolean.FALSE);
    }

    public static boolean isUseSystemPayments() {
        return ReportProperty.find(ReportGroup.SATA, USE_SYSTEM_PAYMENTS).getBooleanValue(Boolean.FALSE);
    }

    public static boolean isOtherInclPettyCash() {
        return ReportProperty.find(ReportGroup.SATA, OTHER_INC_PETTY_CASH).getBooleanValue(Boolean.FALSE);
    }

    public static boolean isVarianceBetweenSalesAndTakings() {
        return ReportProperty.find(ReportGroup.SATA, VARIANCE_BETWEEN_SALES_AND_TAKINGS).getBooleanValue(Boolean.FALSE);
    }

    public static boolean isTotalEftposPerCashdrawer() {
        return ReportProperty.find(ReportGroup.SATA, TOTAL_EFTPOS_PER_CASHDRAWER).getBooleanValue(Boolean.FALSE);
    }

    public static String getHiddenColumns() {
        return ReportProperty.find(ReportGroup.SATA, HIDDEN_COLUMNS).getStringValue("");
    }
}

