/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import java.awt.Color;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportBySIQCompiler;
import ordermate.database.reports.sata.SATAReportColumns;
import ordermate.database.reports.sata.SATAReportCompiler;
import ordermate.database.reports.sata.SATAReportProperties;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.GenericBiListTableModel;

public class SATAReportProvider
extends AbstractReportProvider {
    static final String EX_TAX = "*";
    static final String EX_ADJ = "^";
    private static String TOTAL_EX_MATCHER = SATAReportColumns.TOTAL_EX.getName();
    private Set<String> boldNames;
    private List<String> colNames;
    private DateFormat format = DateTimeUtils.getDateMonthYearFormat();
    private SATAReportCompiler compiler;
    private boolean useSystemPayment;
    private boolean includePettyCashInOther;
    private String hiddenCols = "";
    private boolean groupByDayParts = false;

    public SATAReportProvider(SATAReportCompiler compiler) {
        this.compiler = compiler;
        this.boldNames = new HashSet<String>();
        this.boldNames.add(this.getColNameOfTotal());
        this.boldNames.add(this.getColNameOfNetSales());
        this.boldNames.add(SATAReportColumns.GROSS_SALES.getName());
        this.boldNames.add(SATAReportColumns.DEBTORS.getName());
        this.boldNames.add(SATAReportColumns.SYSTEM_TAKINGS.getName());
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        JRTableModelDataSource dataSource = new JRTableModelDataSource(this.createTableModel());
        return dataSource;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        this.useSystemPayment = SATAReportProperties.isUseSystemPayments();
        this.includePettyCashInOther = SATAReportProperties.isOtherInclPettyCash();
        this.hiddenCols = SATAReportProperties.getHiddenColumns();
        this.colNames = null;
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle(), ReportBuilder.TemplateFormat.A4Landscape);
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle(this.compiler.getTitle() + this.format.format(this.compiler.getFrom()) + " - " + this.format.format(this.compiler.getTo()));
        String subtitle = this.compiler.getSubTitle();
        if (subtitle != null) {
            builder.setSubtitle(subtitle);
        }
        Page page = Page.Page_Letter_Landscape();
        builder.getReportBuilder().setPageSizeAndOrientation(page);
        builder.getReportBuilder().setPrintBackgroundOnOddRows(false);
        builder.getReportBuilder().setDetailHeight(10);
        builder.getReportBuilder().setHeaderHeight(20);
        Style greyHeader = null;
        Style boldStyle = null;
        Style normalStyle = null;
        try {
            normalStyle = (Style)builder.getStyles().getColumnDetailStyle().clone();
            boldStyle = (Style)builder.getStyles().getColumnDetailStyle().clone();
            boldStyle.getFont().setBold(true);
            greyHeader = (Style)builder.getStyles().getColumnHeaderStyle().clone();
            greyHeader.setBackgroundColor(Color.DARK_GRAY);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        this.getColumnNames();
        SimpleColumn column = this.makeColumn("Date", String.class);
        column.setWidth(Integer.valueOf(30));
        column.setFixedWidth(Boolean.TRUE);
        column.setStyle(boldStyle);
        builder.getReportBuilder().addColumn((AbstractColumn)column);
        boolean doGrey = true;
        HashSet<String> hiddenColumnsSet = new HashSet<String>(StringUtils.splitToList(SATAReportProperties.getHiddenColumns(), ","));
        for (int i = 1; i < this.colNames.size(); ++i) {
            String name = this.colNames.get(i);
            if (hiddenColumnsSet.contains(name)) continue;
            column = this.makeColumn(name, String.class);
            if (doGrey) {
                column.setHeaderStyle(greyHeader);
            }
            if (this.boldNames.contains(name)) {
                column.setStyle(boldStyle);
                doGrey = !doGrey;
            } else {
                column.setStyle(normalStyle);
            }
            if ("Covers".equals(name)) {
                column.setWidth(Integer.valueOf(20));
            }
            builder.getReportBuilder().addColumn((AbstractColumn)column);
        }
        return builder;
    }

    private SimpleColumn makeColumn(String name, Class clazz) {
        return JasperReportHelper.makeColumn(name, clazz);
    }

    public TableModel createTableModel() {
        if (this.getCachedResults() == null || this.getCachedResults().isEmpty()) {
            this.compiler.performReport();
        }
        this.groupByDayParts = this.compiler instanceof SATAReportBySIQCompiler && ((SATAReportBySIQCompiler)this.compiler).isGroupByDayParts();
        this.colNames = null;
        this.useSystemPayment = SATAReportProperties.isUseSystemPayments();
        this.includePettyCashInOther = SATAReportProperties.isOtherInclPettyCash();
        List colData = this.getColumnData();
        GenericBiListTableModel model = new GenericBiListTableModel(this.getColumnNames(), colData);
        return model;
    }

    private List<String> getColumnNames() {
        if (this.colNames != null) {
            return this.colNames;
        }
        TOTAL_EX_MATCHER = SATAReportColumns.TOTAL_EX.getName();
        SATAReport report = this.getCachedResults().get(0);
        ArrayList<String> names = new ArrayList<String>();
        names.add(SATAReportColumns.DATE.getName());
        if (this.groupByDayParts) {
            names.add(SATAReportColumns.DAY_PART.getName());
        }
        for (Pair<InventoryCategory, Price> pair : report.getCatSales()) {
            names.add(this.getColNameOfCategory(pair.getKey().getLabel()));
        }
        names.add(this.getColNameOfTotal());
        names.add(this.getColNameOfAdjustment(SATAReportColumns.DISCOUNTS.getName()));
        names.add(this.getColNameOfAdjustment(SATAReportColumns.SURCHARGES.getName()));
        names.add(this.getColNameOfNetSales());
        names.add(SATAReportColumns.TAX_FREE.getName());
        if (report.getTaxes().size() > 1) {
            for (Pair<PersistentObject, Price> pair : report.getTaxes()) {
                names.add(((TaxCode)pair.getKey()).getCode());
            }
        }
        names.add(SATAReportColumns.TOTAL_TAX.getName());
        names.add(SATAReportColumns.GROSS_SALES.getName());
        names.add(SATAReportColumns.DEBTORS.getName());
        names.add(SATAReportColumns.VOUCHER_TOPUP.getName());
        for (Pair<Object, Price> pair : report.getFinancePayments()) {
            String label = (String)pair.getKey();
            if (StringUtils.isEmpty(label)) continue;
            if (label.startsWith("Master")) {
                label = "M/Card";
            } else if (label.startsWith("Internet")) {
                label = "Internet Payment";
            }
            names.add(label);
        }
        if (!this.includePettyCashInOther) {
            names.add(SATAReportColumns.PETTY_CASH.getName());
        }
        names.add(SATAReportColumns.VOUCHER_REDEEM.getName());
        if (!this.compiler.canUseReconciliation()) {
            names.add(SATAReportColumns.SYSTEM_TAKINGS.getName());
        } else {
            if (this.useSystemPayment) {
                names.add(SATAReportColumns.SYSTEM_TAKINGS.getName());
                names.add(SATAReportColumns.ACTUAL_TAKINGS.getName());
            } else {
                names.add(SATAReportColumns.ACTUAL_TAKINGS.getName());
                names.add(SATAReportColumns.SYSTEM_TAKINGS.getName());
            }
            names.add(SATAReportColumns.VARIANCE.getName());
        }
        if (!this.hiddenCols.contains(SATAReportColumns.COVERS.getName())) {
            names.add(SATAReportColumns.COVERS.getName());
        }
        this.colNames = names;
        return this.colNames;
    }

    String getColNameOfCategory(String categoryLabel) {
        StringBuilder sb = new StringBuilder(categoryLabel);
        if (!SATAReportProperties.isCatSalesInclTax()) {
            sb.append(EX_TAX);
        }
        if (!SATAReportProperties.isCatSalesAfterAdjustments()) {
            sb.append(EX_ADJ);
        }
        return sb.toString().replace("\"", "");
    }

    String getColNameOfTotal() {
        StringBuilder sb = new StringBuilder(SATAReportColumns.TOTAL_EX.getName());
        if (!SATAReportProperties.isCatSalesInclTax()) {
            sb.append(EX_TAX);
            TOTAL_EX_MATCHER = TOTAL_EX_MATCHER.concat(EX_TAX);
        }
        if (!SATAReportProperties.isCatSalesAfterAdjustments()) {
            sb.append(EX_ADJ);
            TOTAL_EX_MATCHER = TOTAL_EX_MATCHER.concat(EX_ADJ);
        }
        return sb.toString();
    }

    String getColNameOfNetSales() {
        StringBuilder sb = new StringBuilder(SATAReportColumns.NET_SALES.getName());
        if (!SATAReportProperties.isNetSalesInclTax()) {
            sb.append(EX_TAX);
        }
        return sb.toString();
    }

    String getColNameOfAdjustment(String adjustmentName) {
        StringBuilder sb = new StringBuilder(adjustmentName);
        if (!SATAReportProperties.isAdjustmentInclTax()) {
            sb.append(EX_TAX);
        }
        return sb.toString();
    }

    public List<SATAReport> getCachedResults() {
        return this.compiler.getCachedResults();
    }

    private List<List<Object>> getColumnData() {
        ArrayList<List<Object>> matrix = new ArrayList<List<Object>>();
        if (this.getCachedResults().isEmpty()) {
            return matrix;
        }
        int expectedSize = this.calculateExpectedSize(this.getCachedResults().get(0));
        ArrayList<Object> totals = new ArrayList<Object>(expectedSize);
        ArrayList<Object> percs = new ArrayList<Object>(expectedSize);
        Double ZERO = 0.0;
        for (int i = 0; i < expectedSize - 1; ++i) {
            totals.add(ZERO);
            percs.add(null);
        }
        totals.add(new Integer(0));
        percs.add(null);
        totals.set(0, "Total");
        percs.set(0, "Gross %");
        int col = 0;
        boolean multiTax = this.getCachedResults().get(0).getTaxes().size() > 1;
        for (SATAReport report : this.getCachedResults()) {
            int i;
            col = 0;
            ArrayList<Object> dataList = new ArrayList<Object>(expectedSize);
            dataList.add(this.format.format(report.getDate()));
            ++col;
            if (this.groupByDayParts) {
                dataList.add(report.getDayPart().getLabel());
                ++col;
            }
            List<Pair<InventoryCategory, Price>> catSales = report.getCatSales();
            for (int i2 = 0; i2 < catSales.size(); ++i2) {
                col = this.add(dataList, totals, col, catSales.get(i2).getValue());
            }
            col = this.add(dataList, totals, col, report.getCategoriesTotal());
            col = this.add(dataList, totals, col, report.getDiscounts());
            col = this.add(dataList, totals, col, report.getSurcharges());
            col = this.add(dataList, totals, col, report.getNet());
            col = this.add(dataList, totals, col, report.getTaxFreeSales());
            if (multiTax) {
                List<Pair<TaxCode, Price>> taxes = report.getTaxes();
                for (i = 0; i < taxes.size(); ++i) {
                    col = this.add(dataList, totals, col, taxes.get(i).getValue());
                }
            }
            col = this.add(dataList, totals, col, report.getTotalTax());
            col = this.add(dataList, totals, col, report.getGross());
            col = this.add(dataList, totals, col, report.getDebtors());
            col = this.add(dataList, totals, col, report.getTotalVoucherTopup().add(report.getTotalVoucherTopupReversal()));
            List<Pair<String, Price>> payments = report.getFinancePayments();
            for (i = 0; i < payments.size(); ++i) {
                col = this.add(dataList, totals, col, payments.get(i).getValue());
            }
            if (!this.includePettyCashInOther) {
                col = this.add(dataList, totals, col, report.getPettyCash());
            }
            col = this.add(dataList, totals, col, report.getTotalVoucherRedeem().subtract(report.getTotalVoucherRedeemReversal()));
            if (!this.compiler.canUseReconciliation()) {
                col = this.add(dataList, totals, col, report.getSystemTakings());
            } else {
                if (this.useSystemPayment) {
                    col = this.add(dataList, totals, col, report.getSystemTakings());
                    col = this.add(dataList, totals, col, report.getActualTakings());
                } else {
                    col = this.add(dataList, totals, col, report.getActualTakings());
                    col = this.add(dataList, totals, col, report.getSystemTakings());
                }
                col = this.add(dataList, totals, col, report.getVariance());
            }
            if (!this.hiddenCols.contains(SATAReportColumns.COVERS.getName())) {
                col = this.add(dataList, totals, col, report.getCovers());
            }
            matrix.add(dataList);
        }
        this.doTotals(totals, percs);
        matrix.add(totals);
        matrix.add(percs);
        return matrix;
    }

    private int add(List<Object> dataList, List<Object> totals, int column, Object value) {
        if (column < totals.size()) {
            dataList.add(value.toString());
            if (value instanceof Integer) {
                totals.set(column, ((Number)totals.get(column)).intValue() + (Integer)value);
            } else {
                totals.set(column, ((Number)totals.get(column)).doubleValue() + ((Price)value).doubleValue());
            }
        }
        return column + 1;
    }

    private int calculateExpectedSize(SATAReport bookKeepingReport) {
        int size = 12;
        if (this.groupByDayParts) {
            size = 11;
        }
        size += bookKeepingReport.getCatSales().size();
        size += bookKeepingReport.getFinancePayments().size();
        size += 2;
        if (!this.includePettyCashInOther) {
            ++size;
        }
        if (!this.hiddenCols.contains(SATAReportColumns.COVERS.getName())) {
            ++size;
        }
        if (bookKeepingReport.getTaxes().size() > 1) {
            size += bookKeepingReport.getTaxes().size();
        }
        return size;
    }

    private void doTotals(List<Object> totals, List<Object> percs) {
        int skipIndex = 1;
        if (this.groupByDayParts) {
            skipIndex = 2;
            totals.set(1, "");
        }
        DecimalFormat percFormat = new DecimalFormat("0.0%");
        int catTotalIndex = this.getColumnNames().indexOf(TOTAL_EX_MATCHER);
        double totalEx = (Double)totals.get(catTotalIndex);
        for (int i = skipIndex; i < catTotalIndex; ++i) {
            double value = (Double)totals.get(i);
            percs.set(i, totalEx == 0.0 ? null : percFormat.format(value / totalEx));
        }
        int discIndex = catTotalIndex + 1;
        int surIndex = catTotalIndex + 2;
        percs.set(discIndex, totalEx == 0.0 ? null : percFormat.format((Double)totals.get(discIndex) / totalEx));
        percs.set(surIndex, totalEx == 0.0 ? null : percFormat.format((Double)totals.get(surIndex) / totalEx));
        for (int i = skipIndex; i < totals.size() - 1; ++i) {
            totals.set(i, new Price((Double)totals.get(i), 0.0).toString());
        }
        if (!this.hiddenCols.contains(SATAReportColumns.COVERS.getName())) {
            totals.set(totals.size() - 1, totals.get(totals.size() - 1));
        }
    }

    public void setCompiler(SATAReportCompiler value) {
        this.compiler = value;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "* = Excludes Tax, ^ = Excludes Discounts & Surcharges";
    }
}

