/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.reports.CategorySalesReport;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.SATAReportProperties;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.CategoryReportSearcher;

class SalesByCategoryCompiler
extends AbstractSATACompiler {
    private CategoryReportSearcher searcher = new ExTaxIncAdjCategoryReportSearcher();

    SalesByCategoryCompiler() {
    }

    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        boolean incTaxProperty = SATAReportProperties.isCatSalesInclTax();
        boolean incAdjProperty = SATAReportProperties.isCatSalesAfterAdjustments();
        if (incTaxProperty && incAdjProperty) {
            this.searcher = new IncTaxIncAdjCategoryReportSearcher();
        } else if (!incTaxProperty && incAdjProperty) {
            this.searcher = new ExTaxIncAdjCategoryReportSearcher();
        } else if (incTaxProperty && !incAdjProperty) {
            this.searcher = new IncTaxExAdjCategoryReportSearcher();
        } else if (!incTaxProperty && !incAdjProperty) {
            this.searcher = new ExTaxExAdjCategoryReportSearcher();
        }
        if (this.siqTradingDay) {
            this.searcher.setTradingDayBySIQ(this.siqTradingDay);
            this.searcher.groupByDayPart(this.groupByDayParts);
            this.searcher.getSalesLocationFilter().setSearchValue(this.salesLocations);
        }
        this.searcher.getTradingDayDateRangeAdapter().setStart(this.getFrom());
        this.searcher.getTradingDayDateRangeAdapter().setEnd(this.getTo());
        this.searcher.groupByTradingDay(true);
        List<InventoryCategory> categories = InventoryCategory.getAllCategories();
        ArrayList<String> catNames = new ArrayList<String>(categories.size());
        for (InventoryCategory cat : categories) {
            for (SATAReport report : reportMap.values()) {
                report.getCatSales().add(new Pair<InventoryCategory, Price>(cat, Price.ZERO_NO_ROUND));
            }
            catNames.add(cat.getLabel());
        }
        List<CategorySalesReport> catSales = this.searcher.search();
        for (CategorySalesReport catReport : catSales) {
            int catIndex = catNames.indexOf(catReport.getInventoryCategoryName());
            if (catIndex == -1) {
                InventoryCategory defCat = InventoryCategory.getDefaultCategory();
                catIndex = catNames.indexOf(defCat.getName());
                if (catIndex == -1) {
                    catNames.add(defCat.getName());
                    for (SATAReport nextReport : reportMap.values()) {
                        nextReport.getCatSales().add(new Pair<InventoryCategory, Price>(defCat, Price.ZERO_DOLLAR));
                    }
                }
                catIndex = catNames.indexOf(defCat.getName());
            }
            Pair<InventoryCategory, Price> miniReport = reportMap.get(SATAReport.createId(catReport.getTradingDay(), catReport.getDayPart())).getCatSales().get(catIndex);
            miniReport.setValue(miniReport.getValue().add(catReport.getSalesValue()));
        }
    }

    static class IncTaxExAdjCategoryReportSearcher
    extends CategoryReportSearcher {
        IncTaxExAdjCategoryReportSearcher() {
        }

        @Override
        public ObjectQuery getBaseQuery() {
            ObjectQuery query = Query.select(InventoryCategory.Properties.LABEL, "category_name").selectFunc("(SUM(" + SalesItemQuantity.Properties.QUANTITY + " * (" + SalesComponent.Properties.SAVED_UNIT_PRICE + " + " + SalesComponent.Properties.ITEM_DISCOUNT_TOTAL + " + " + SalesComponent.Properties.ACCOUNT_DISCOUNT_TOTAL + " + " + SalesComponent.Properties.ACCOUNT_SURCHARGE_TOTAL + " + " + SalesComponent.Properties.ITEM_SURCHARGE_TOTAL + "))) AS sales_value ").selectFunc("0.0 AS quantity_sold ").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(InventoryItem.Properties.CATEGORY).groupBy(InventoryCategory.Properties.LABEL).orderBy(InventoryCategory.Properties.LABEL);
            return query;
        }
    }

    static class ExTaxExAdjCategoryReportSearcher
    extends CategoryReportSearcher {
        ExTaxExAdjCategoryReportSearcher() {
        }

        @Override
        public ObjectQuery getBaseQuery() {
            ObjectQuery query = Query.select(InventoryCategory.Properties.LABEL, "category_name").selectFunc("(SUM(" + SalesItemQuantity.Properties.QUANTITY + " * (" + SalesComponent.Properties.SAVED_UNIT_PRICE + " - " + SalesComponent.Properties.UNIT_TAX_AMOUNT + " + " + SalesComponent.Properties.ITEM_DISCOUNT_TOTAL + " + " + SalesComponent.Properties.ACCOUNT_DISCOUNT_TOTAL + " + " + SalesComponent.Properties.ACCOUNT_SURCHARGE_TOTAL + " + " + SalesComponent.Properties.ITEM_SURCHARGE_TOTAL + "))) AS sales_value ").selectFunc("0.0 AS quantity_sold ").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(InventoryItem.Properties.CATEGORY).groupBy(InventoryCategory.Properties.LABEL).orderBy(InventoryCategory.Properties.LABEL);
            return query;
        }
    }

    static class IncTaxIncAdjCategoryReportSearcher
    extends CategoryReportSearcher {
        IncTaxIncAdjCategoryReportSearcher() {
        }

        @Override
        public ObjectQuery getBaseQuery() {
            ObjectQuery query = Query.select(InventoryCategory.Properties.LABEL, "category_name").selectFunc("SUM(" + SalesItemQuantity.Properties.QUANTITY + " * (" + SalesComponent.Properties.SAVED_UNIT_PRICE + ")) AS sales_value ").selectFunc("0.0 AS quantity_sold ").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(InventoryItem.Properties.CATEGORY).groupBy(InventoryCategory.Properties.LABEL).orderBy(InventoryCategory.Properties.LABEL);
            return query;
        }
    }

    static class ExTaxIncAdjCategoryReportSearcher
    extends CategoryReportSearcher {
        ExTaxIncAdjCategoryReportSearcher() {
        }

        @Override
        public ObjectQuery getBaseQuery() {
            ObjectQuery query = Query.select(InventoryCategory.Properties.LABEL, "category_name").selectFunc("SUM(" + SalesItemQuantity.Properties.QUANTITY + " * (" + SalesComponent.Properties.SAVED_UNIT_PRICE + " - " + SalesComponent.Properties.UNIT_TAX_AMOUNT + ")) AS sales_value ").selectFunc("0.0 AS quantity_sold ").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(InventoryItem.Properties.CATEGORY).groupBy(InventoryCategory.Properties.LABEL).orderBy(InventoryCategory.Properties.LABEL);
            return query;
        }
    }
}

