/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import java.util.List;
import java.util.Map;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.sata.TakingsSearcher;
import ordermate.database.reports.takings.DailyTakingsReport;

class TakingsCompiler
extends AbstractSATACompiler {
    private TakingsSearcher searcher = new TakingsSearcher();

    TakingsCompiler() {
    }

    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        this.searcher.getTradingDayFilter().setStart(this.getFrom());
        this.searcher.getTradingDayFilter().setEnd(this.getTo());
        this.searcher.getSalesLocationFilter().setSearchValue(this.salesLocations);
        this.searcher.setGroupByDayParts(this.groupByDayParts);
        List<DailyTakingsReport> reports = this.searcher.search();
        for (DailyTakingsReport report : reports) {
            SATAReport bkReport = reportMap.get(SATAReport.createId(report.getTradingDay(), report.getDayPart()));
            if (bkReport == null) continue;
            bkReport.setActualTakings(bkReport.getActualTakings().add(report.getActualTakings()));
            bkReport.setSystemTakings(bkReport.getSystemTakings().add(report.getSystemTakings()));
        }
    }
}

