/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.reconciliation.CashdrawerReconciliation;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.TerminalLocation;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.takings.DailyTakingsReport;

class TakingsSearcher
extends PropertySearcher<DailyTakingsReport> {
    private IRangedQuerySearchFilter<Date> tradingDayFilter;
    private MultiOptionSearchFilter terminalLocationFilter;
    private MultiOptionSearchFilter salesLocationFilter;
    private boolean groupByDayParts = false;

    TakingsSearcher() {
        super(DailyTakingsReport.class);
        this.tradingDayFilter = new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP);
        this.addSearchFilter(new TradingDayDateRangeFilterAdapter(this.tradingDayFilter));
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(FinanceTransaction.Properties.SALES_LOCATION);
        this.addSearchFilter(this.salesLocationFilter);
        this.terminalLocationFilter = new MultiOptionSearchFilter<TerminalLocation>(FinanceTransaction.Properties.LOCATION);
        this.addSearchFilter(this.terminalLocationFilter);
    }

    public void setGroupByDayParts(boolean value) {
        this.groupByDayParts = value;
    }

    IRangedQuerySearchFilter<Date> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    @Override
    public ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(TradingDay.Properties.ID).select(FinanceTransaction.Properties.TRADING_DAY).sum(FinanceTransaction.Properties.PAID, "system_takings").linkUsing(FinanceTransaction.Properties.TRADING_DAY).linkUsing(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.Properties.ID).selectFunc("0 as 'actual_takings'").not().equals(FinanceTransaction.Properties.SYSTEM_STATE, "DELETED").isNull(FinanceTransaction.Properties.MOVED_TRANSACTION).active(FinanceUnit.class).wherePropertyIn(FinanceUnit.Properties.TYPE, new Object[]{FinanceUnit.CASH_TYPE.toString(), FinanceUnit.CREDIT_TYPE.toString(), FinanceUnit.DEBIT_TYPE.toString(), FinanceUnit.WEB_TYPE.toString()}).orderBy(FinanceTransaction.Properties.TRADING_DAY).groupBy(FinanceTransaction.Properties.TRADING_DAY);
        if (this.groupByDayParts) {
            query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("finance_transaction.timestamp"));
            query.groupBy("fk_config_day_part");
            query.orderBy("fk_config_day_part", false);
        } else {
            query.selectFunc("null as fk_config_day_part");
        }
        return query;
    }

    public MultiOptionSearchFilter getTerminalLocationFilter() {
        return this.terminalLocationFilter;
    }

    public MultiOptionSearchFilter getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    @Override
    public List<DailyTakingsReport> search() {
        List<DailyTakingsReport> reports = super.search();
        HashMap<Long, DailyTakingsReport> reportMap = new HashMap<Long, DailyTakingsReport>();
        for (DailyTakingsReport report : reports) {
            reportMap.put(SATAReport.createId(report.getTradingDay(), report.getDayPart()), report);
        }
        if (this.performActualTakingsQuery(reportMap)) {
            reports = new ArrayList(reportMap.values());
            List<PropertiedObject.Property<? extends PropertiedObject>> props = Collections.singletonList(DailyTakingsReport.Properties.TRADING_DAY);
            Collections.sort(reports, new PropertyComparator(props, TradingDay.Properties.DATE));
        }
        return reports;
    }

    private boolean performActualTakingsQuery(Map<Long, DailyTakingsReport> reportMap) {
        ObjectQuery query = Query.select(CashdrawerReconciliation.class).linkUsing(CashdrawerReconciliation.Properties.PARENT).linkUsing(ShiftReconciliation.Properties.SHIFT).linkUsing(Shift.Properties.TRADING_DAY).orderBy(Shift.Properties.TRADING_DAY);
        DayPart defaultDayPart = null;
        if (this.groupByDayParts) {
            defaultDayPart = DayPart.getAllDayPartsCached().get(0);
        }
        this.tradingDayFilter.addQueryRestriction(query);
        List<CashdrawerReconciliation> recs = PersistenceManager.getObjectList(CashdrawerReconciliation.class, query.toString());
        boolean addedMissingTradingDay = false;
        for (CashdrawerReconciliation rec : recs) {
            Long id = SATAReport.createId(rec.getParent().getShift().getTradingDay(), defaultDayPart);
            DailyTakingsReport report = reportMap.get(id);
            if (report == null) {
                report = new DailyTakingsReport(rec.getParent().getShift().getTradingDay(), Price.ZERO_NO_ROUND);
                report.setDayPart(defaultDayPart);
                reportMap.put(id, report);
                addedMissingTradingDay = true;
            }
            reportMap.get(id).addActual(rec.getTotal());
        }
        return addedMissingTradingDay;
    }
}

