/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.sata;

import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import java.util.List;
import java.util.Map;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.reports.sata.AbstractSATACompiler;
import ordermate.database.reports.sata.SATAReport;
import ordermate.database.reports.tax.TaxCodeReportItem;
import ordermate.database.reports.tax.TaxCodeReportSearcher;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItemQuantity;

class TaxByTypeCompiler
extends AbstractSATACompiler {
    private TaxCodeReportSearcher searcher = new TaxCodeReportSearcher();

    @Override
    public void populateMap(Map<Long, SATAReport> reportMap) {
        SATAReport sataReport;
        this.searcher.setTradingDayBySIQ(this.siqTradingDay, this.groupByDayParts);
        if (this.siqTradingDay) {
            this.searcher.getSalesLocationFilter().setSearchValue(this.salesLocations);
        }
        this.searcher.setSearchType(TaxCodeReportSearcher.TaxSearchType.TaxPayable);
        this.searcher.getTradingDayDateRangeAdapter().setStart(this.getFrom());
        this.searcher.getTradingDayDateRangeAdapter().setEnd(this.getTo());
        if (this.siqTradingDay) {
            this.searcher.addGroupBy(SalesItemQuantity.Properties.TRADING_DAY);
        } else {
            this.searcher.addGroupBy(Account.Properties.TRADING_DAY);
        }
        TaxCode freeCode = TaxCode.getFreeCode();
        List<TaxCode> activeCodes = TaxCode.getInventoryTaxCodes();
        for (TaxCode code : activeCodes) {
            if (freeCode.equals(code)) continue;
            for (SATAReport report : reportMap.values()) {
                report.getTaxes().add(new Pair<TaxCode, Price>(code, Price.ZERO_NO_ROUND));
            }
        }
        List<TaxCodeReportItem> reports = this.searcher.search();
        for (TaxCodeReportItem report : reports) {
            Pair<TaxCode, Price> taxCodePricePair;
            if (freeCode.equals(report.getTaxCode()) || report.getTradingDay() == null || (taxCodePricePair = this.getIndex((sataReport = reportMap.get(SATAReport.createId(report.getTradingDay(), report.getDayPart()))).getTaxes(), report.getTaxCode())) == null) continue;
            Pair<TaxCode, Price> miniReport = taxCodePricePair;
            miniReport.setValue(miniReport.getValue().add(report.getAmount()));
        }
        this.searcher.setSearchType(TaxCodeReportSearcher.TaxSearchType.TotalTaxSales);
        reports = this.searcher.search();
        for (TaxCodeReportItem report : reports) {
            if (!freeCode.equals(report.getTaxCode()) || report.getTradingDay() == null) continue;
            sataReport = reportMap.get(SATAReport.createId(report.getTradingDay(), report.getDayPart()));
            sataReport.setTaxFreeSales(sataReport.getTaxFreeSales().add(report.getAmount()));
        }
    }

    private Pair<TaxCode, Price> getIndex(List<Pair<TaxCode, Price>> taxCodeList, TaxCode taxCode) {
        for (int i = 0; i < taxCodeList.size(); ++i) {
            Pair<TaxCode, Price> taxCodePricePair = taxCodeList.get(i);
            if (!taxCodePricePair.getKey().equals(taxCode)) continue;
            return taxCodePricePair;
        }
        return null;
    }
}

