/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.snapshot;

import au.com.ordermate.util.Price;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.DayPart;
import ordermate.database.reports.dailysummary.AbstractDailySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyPatronsReport;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportType;
import ordermate.internationalization.Internationalization;

public class SalesReportCompiler
extends AbstractDailySummaryReportCompiler<DailySalesSummaryReport> {
    private DayPart dayPart;
    private SalesLocation location;
    private DailySummaryReportType reportType;
    Map<String, List<DailySalesSummaryReport>> reportMap;
    private List<DailyPatronsReport> patrons = null;
    private String currentLabel;

    public SalesReportCompiler(SalesLocation location, DayPart part, List<DailySalesSummaryReport> reports, DailySummaryReportType theReportType, List<DailyPatronsReport> patronsReport) {
        this.dayPart = part;
        this.reportType = theReportType;
        this.location = location;
        this.patrons = patronsReport;
        this.reportMap = this.loadLabelMap(reports);
    }

    @Override
    public List<String> getColumnNames() {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add(this.getPrimaryColumnName());
        newList.add("Monday");
        newList.add("Tuesday");
        newList.add("Wednesday");
        newList.add("Thursday");
        newList.add("Friday");
        newList.add("Saturday");
        newList.add("Sunday");
        newList.add("Total");
        return newList;
    }

    @Override
    public List<List<String>> getReportData() {
        this.currentLabel = "columnarTotal";
        List<DailySalesSummaryReport> columnarTotals = this.createColumnarTotalsReports(this.reportMap);
        ArrayList<String> labelList = new ArrayList<String>(this.reportMap.keySet());
        Collections.sort(labelList);
        List<List<String>> rows = this.makeSummaryRows(labelList, this.reportMap, columnarTotals);
        return rows;
    }

    private Map<String, List<DailySalesSummaryReport>> loadLabelMap(List<DailySalesSummaryReport> reportList) {
        HashMap labelMap = new HashMap();
        for (DailySalesSummaryReport dailySalesSummaryReport : reportList) {
            if (!labelMap.containsKey(dailySalesSummaryReport.getLabel())) {
                labelMap.put(dailySalesSummaryReport.getLabel(), new HashMap());
            }
            if (this.location != null && !this.location.equals(dailySalesSummaryReport.getLocation()) || this.dayPart != null && !this.dayPart.getLabel().equals(dailySalesSummaryReport.getDayPart())) continue;
            if (((Map)labelMap.get(dailySalesSummaryReport.getLabel())).containsKey(dailySalesSummaryReport.getDayOfWeek())) {
                ((DailySalesSummaryReport)((Map)labelMap.get(dailySalesSummaryReport.getLabel())).get(dailySalesSummaryReport.getDayOfWeek())).add(dailySalesSummaryReport);
                continue;
            }
            ((Map)labelMap.get(dailySalesSummaryReport.getLabel())).put(dailySalesSummaryReport.getDayOfWeek(), dailySalesSummaryReport);
        }
        Map nextMap = null;
        Iterator iterator = labelMap.keySet().iterator();
        while (iterator.hasNext()) {
            String label;
            this.currentLabel = label = (String)iterator.next();
            nextMap = (Map)labelMap.get(label);
            this.insertMissingReports(nextMap);
            this.addRowTotalsReport(nextMap);
        }
        this.currentLabel = null;
        if (nextMap != null) {
            this.updateNumPatrons(nextMap);
        }
        HashMap<String, List<DailySalesSummaryReport>> hashMap = new HashMap<String, List<DailySalesSummaryReport>>();
        for (String nextLabel : labelMap.keySet()) {
            ArrayList list = new ArrayList(((Map)labelMap.get(nextLabel)).values());
            this.sortListByDayOfWeek(list);
            hashMap.put(nextLabel, list);
        }
        return hashMap;
    }

    protected void updateNumPatrons(Map<Integer, DailySalesSummaryReport> toUpdate) {
        if (this.patrons == null) {
            return;
        }
        int total = 0;
        for (DailyPatronsReport patronReport : this.patrons) {
            DailySalesSummaryReport nextReport = toUpdate.get(patronReport.getDayOfWeek());
            total += patronReport.getNumPatrons();
            if (nextReport == null) continue;
            nextReport.setNumPatrons(patronReport.getNumPatrons());
        }
        if (toUpdate.containsKey(null)) {
            toUpdate.get(null).setNumPatrons(total);
        }
    }

    @Override
    protected List<DailySalesSummaryReport> createColumnarTotalsReports(Map<String, List<DailySalesSummaryReport>> reportMap) {
        ArrayList<DailySalesSummaryReport> columnTotals = new ArrayList<DailySalesSummaryReport>();
        for (int i = 0; i < 7; ++i) {
            columnTotals.add(this.createEmptyReport(i + 1));
        }
        columnTotals.add(this.createEmptyReport(null));
        for (List<DailySalesSummaryReport> nextList : reportMap.values()) {
            for (DailySalesSummaryReport report : nextList) {
                if (report.getDayOfWeek() != null) continue;
                ((DailySalesSummaryReport)columnTotals.get(columnTotals.size() - 1)).add(report);
            }
        }
        return columnTotals;
    }

    private List<List<String>> makeSummaryRows(List<String> labelList, Map<String, List<DailySalesSummaryReport>> reportMap, List<DailySalesSummaryReport> columnarTotals) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (String nextLabel : labelList) {
            this.makeSummaryRows(nextLabel, reportMap.get(nextLabel), columnarTotals, rows);
        }
        ArrayList<String> patronRow = new ArrayList<String>();
        patronRow.add(Internationalization.getLiteralFor("COVERS"));
        ArrayList<String> dollarsRow = new ArrayList<String>();
        dollarsRow.add(Internationalization.getLiteralFor("DOLLAR_SIGN") + " / " + Internationalization.getLiteralFor("COVER"));
        ArrayList<String> salesExRow = new ArrayList<String>();
        salesExRow.add("Sales Ex Tax");
        ArrayList<String> taxRow = new ArrayList<String>();
        taxRow.add("Tax");
        ArrayList<String> salesIncRow = new ArrayList<String>();
        salesIncRow.add("Sales Inc Tax");
        ArrayList<String> discountsRow = new ArrayList<String>();
        discountsRow.add("Discounts");
        boolean hasPatrons = false;
        for (DailySalesSummaryReport report : columnarTotals) {
            if (report.getNumPatrons() != null) {
                int numPatrons = report.getNumPatrons();
                hasPatrons = true;
                patronRow.add(String.valueOf(numPatrons));
                Price price = report.getDollarsPerHead();
                dollarsRow.add(price.toString(true));
            } else {
                patronRow.add(String.valueOf(0));
                dollarsRow.add(Price.ZERO_DOLLAR.toString(true));
            }
            salesExRow.add(report.getSalesEx().toString(true));
            taxRow.add(report.getTax().toString(true));
            salesIncRow.add(report.getSalesInc().toString(true));
            discountsRow.add(report.getDiscounts().toString(true));
        }
        rows.add(salesExRow);
        rows.add(taxRow);
        rows.add(salesIncRow);
        rows.add(discountsRow);
        if (hasPatrons) {
            rows.add(patronRow);
            rows.add(dollarsRow);
        }
        return rows;
    }

    private void makeSummaryRows(String label, List<DailySalesSummaryReport> theReportList, List<DailySalesSummaryReport> columnarTotals, List<List<String>> rows) {
        ArrayList<String> salesRow = new ArrayList<String>();
        salesRow.add(label + " Sales");
        rows.add(salesRow);
        boolean requiresDetail = this.reportType.requiresDetailPerSection();
        ArrayList<String> percSalesRow = new ArrayList<String>();
        ArrayList<String> discountsRow = new ArrayList<String>();
        ArrayList<String> refundsRow = new ArrayList<String>();
        if (requiresDetail) {
            percSalesRow.add(label + " %");
            discountsRow.add(label + " Disc");
            refundsRow.add(label + " Ref");
            rows.add(percSalesRow);
            rows.add(discountsRow);
            rows.add(refundsRow);
        }
        NumberFormat percFormat = NumberFormat.getPercentInstance();
        for (int i = 0; i < theReportList.size(); ++i) {
            DailySalesSummaryReport report = theReportList.get(i);
            DailySalesSummaryReport total = columnarTotals.get(0);
            salesRow.add(report.getSalesEx().toString(true));
            if (!requiresDetail) continue;
            percSalesRow.add(Price.ZERO_DOLLAR.equals(total.getSalesEx()) ? "0%" : percFormat.format(report.getSalesEx().doubleValue() / total.getSalesEx().doubleValue()));
            discountsRow.add(report.getDiscounts().toString(true));
            refundsRow.add(report.getRefunds().toString(true));
        }
    }

    @Override
    protected DailySalesSummaryReport createEmptyReport(Integer theDayOfWeek) {
        return new DailySalesSummaryReport(theDayOfWeek, this.location, this.dayPart, this.currentLabel);
    }

    @Override
    protected String getPrimaryColumnName() {
        return this.dayPart == null ? "Day Total" : this.dayPart.getLabel();
    }
}

