/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.snapshot;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.dailysummary.DailyDebtorSummaryReport;
import ordermate.database.reports.dailysummary.DailyDebtorSummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyPatronsReport;
import ordermate.database.reports.dailysummary.DailyProductivitySummaryReport;
import ordermate.database.reports.dailysummary.DailyProductivitySummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailyReconciliationSummaryReportCompiler;
import ordermate.database.reports.dailysummary.DailySalesSummaryReport;
import ordermate.database.reports.dailysummary.DailyVoucherSummaryReport;
import ordermate.database.reports.dailysummary.DailyVoucherSummaryReportCompiler;
import ordermate.database.reports.dailysummary.StockSummaryReportCompiler;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.reports.snapshot.SalesReportCompiler;
import ordermate.database.searchers.reports.dailysummary.DailyDebtorSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyProductivitySummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyReconciliationSummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportSearcher;
import ordermate.database.searchers.reports.dailysummary.DailyVoucherSummaryReportSearcher;
import ordermate.database.searchers.reports.snapshot.SnapshotReportParameters;
import ordermate.database.searchers.reports.snapshot.SnapshotReportSearcher;
import ordermate.database.stock.StockTake;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.GenericBiListTableModel;

public class SnapshotTotalByAccountReportProvider
extends AbstractReportProvider {
    private static final String SALES_SUMMARY = "SALES_SUMMARY_";
    private static final String RECONCILIATION_SUMMARY = "REC_SUMMARY";
    private static final String DEBTOR_SUMMARY = "DEBTOR_SUMMARY";
    private static final String PRODUCTIVITY_SUMMARY = "PROD_SUMMARY";
    private static final String STOCK_SUMMARY = "STOCK_SUMMARY";
    private static final String VOUCHER_SUMMARY = "VOUCHER_SUMMARY";
    private SnapshotReportSearcher searcher;
    private List<DailyPatronsReport> patrons;
    private boolean byLocation = false;
    private List<DailySalesSummaryReport> salesReportList;
    private List<DailySalesSummaryReport> originalSalesReportList;

    public SnapshotTotalByAccountReportProvider(SnapshotReportSearcher repSearcher) {
        this.searcher = repSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanArrayDataSource(new Object[]{"DummyData"});
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Snapshot Report by Account Type");
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getParams().getTradingDayDateRangeAdapter(), null);
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.searcher.getParams().getSalesLocationsFilter());
        builder.setSubtitle(SB.toString());
        if (!DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            this.patrons = this.searcher.getPatronsByAccountSearcher().search();
        }
        this.addSalesSubReport(builder);
        this.addDebtorSubReport(builder);
        this.addVoucherSubReport(builder);
        this.addReconciliationSubReport(builder);
        this.addProductivitySubReport(builder);
        if (SystemProperty.getInstance().isStockControlEnabled()) {
            this.addStockControlSubReport(builder);
        }
        return builder;
    }

    public DateRangeSearchFilter getDateRangeFilter() {
        return this.searcher.getParams().getDateFilter();
    }

    private void addSalesSubReport(ReportBuilder superBuilder) {
        SnapshotReportParameters params = this.searcher.getParams();
        if (this.byLocation) {
            List<SalesLocation> locations = params.getSalesLocationsFilter().getSelectedOptions();
            if (locations.isEmpty()) {
                locations = SalesLocation.getSalesLocations();
            }
            for (SalesLocation location : locations) {
                this.addSalesSummaryForLocation(location, superBuilder, params);
            }
        } else {
            this.addSalesSummaryForLocation(null, superBuilder, params);
        }
    }

    private void addSalesSummaryForLocation(SalesLocation location, ReportBuilder superBuilder, SnapshotReportParameters params) {
        this.salesReportList = this.searcher.getSalesSearcher().search();
        ArrayList<DailySalesSummaryReport> list = new ArrayList<DailySalesSummaryReport>();
        for (DailySalesSummaryReport dailySalesSummaryReport : this.salesReportList) {
            try {
                DailySalesSummaryReport clone = (DailySalesSummaryReport)dailySalesSummaryReport.clone();
                list.add(clone);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot clone DailySalesSummaryReport : ", (Throwable)ex);
            }
        }
        this.originalSalesReportList = list;
        superBuilder.setTitle("Snapshot");
        List<DayPart> parts = params.getDayParts();
        if (parts.size() > 1) {
            for (DayPart part : parts) {
                SalesReportCompiler cultivator = new SalesReportCompiler(location, part, this.salesReportList, params.getReportType(), null);
                try {
                    this.addDailySalesSubReport(location, part, cultivator, superBuilder);
                }
                catch (DJBuilderException ex) {
                    OrderMate.LOG.error("Cannot build summary report : ", (Throwable)ex);
                }
            }
        }
        SalesReportCompiler salesReportCompiler = new SalesReportCompiler(location, null, this.salesReportList, params.getReportType(), this.patrons);
        try {
            this.addDailySalesSubReport(location, null, salesReportCompiler, superBuilder);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot build total summary report : ", (Throwable)ex);
        }
    }

    private void addDailySalesSubReport(SalesLocation location, DayPart part, SalesReportCompiler compiler, ReportBuilder superBuilder) throws DJBuilderException {
        String dataLabel = part == null ? "SALES_SUMMARY_Total" : SALES_SUMMARY + part.getLabel();
        dataLabel = dataLabel + (location == null ? "ALL" : location.getLabel());
        JRTableModelDataSource source = new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData()));
        this.getParameters().put(dataLabel, source);
        superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder(this.makeSalesTitle(location, part), false, false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), dataLabel, 0, 10);
    }

    private String makeSalesTitle(SalesLocation location, DayPart part) {
        StringBuilder SB = new StringBuilder();
        if (part == null) {
            SB.append("Total");
        } else {
            SB.append(part.getLabel());
        }
        SB.append(" For ");
        if (location == null) {
            SB.append("All Locations");
        } else {
            SB.append(location.getLabel());
        }
        return SB.toString();
    }

    private void addStockControlSubReport(ReportBuilder superBuilder) {
        StockTake take = StockTake.getLastSavedStockTake();
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        if (take == null || cal.getTime().after(take.getDate())) {
            OrderMate.LOG.info("Will not perform Stock Control Summary for Daily Summary Report : Stocktake has not been completed in over a year.");
            return;
        }
        ReportBuilder builder = new ReportBuilder();
        SnapshotReportParameters params = this.searcher.getParams();
        StockSummaryReportCompiler compiler = new StockSummaryReportCompiler(params.getEnd());
        this.getParameters().put(STOCK_SUMMARY, new JRBeanCollectionDataSource(compiler.getReportList()));
        try {
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.OPENING_STOCK, "Opening", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.PURCHASES, "Purchases", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.ADJUSTMENTS, "Adjustments", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.WASTAGE, "Wastage", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.YIELD, "Yield", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.CLOSING_STOCK, "Closing", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.STOCKTAKE_VAR, "Variance", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.COGS, "CoGs $", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.COGS_PERC, "CoGs %", "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.GP, "GP $", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            builder.addReportColumn(PeriodStockAreaReportItem.Properties.GP_PERC, "GP %", "0.00");
        }
        catch (ColumnBuilderException ex) {
            OrderMate.LOG.error("Error with constructing the StockControlSubReport in DailySummaryReportProvider:", (Throwable)ex);
        }
        builder.setTitle("Stock Snapshot");
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(builder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), STOCK_SUMMARY, 0, 10, false);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate debtor sales/payments subreport :", (Throwable)ex);
        }
    }

    private void addDebtorSubReport(ReportBuilder superBuilder) {
        DailyDebtorSummaryReportSearcher debtorSearcher = this.searcher.getDebtorSearcher();
        List<DailyDebtorSummaryReport> primaryReports = debtorSearcher.search();
        List<DailyDebtorSummaryReport> secondaryReports = PersistenceManager.getObjectList(DailyDebtorSummaryReport.class, debtorSearcher.getSalesQuery().toString());
        List<DailyDebtorSummaryReport> tertiaryReports = PersistenceManager.getObjectList(DailyDebtorSummaryReport.class, debtorSearcher.getAdjustmentsQuery().toString());
        DailyDebtorSummaryReportCompiler compiler = new DailyDebtorSummaryReportCompiler(primaryReports, secondaryReports, tertiaryReports);
        super.getParameters().put(DEBTOR_SUMMARY, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder("Debtor Activity Snapshot", false, false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), DEBTOR_SUMMARY, 0, 10, false);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate debtor sales/payments subreport :", (Throwable)ex);
        }
    }

    private void addVoucherSubReport(ReportBuilder superBuilder) {
        DailyVoucherSummaryReportSearcher voucherSearcher = this.searcher.getVoucherSearcher();
        List<DailyVoucherSummaryReport> topupsReports = voucherSearcher.search();
        List<DailyVoucherSummaryReport> topupReversalsReports = PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, voucherSearcher.getTopupReversalsQuery().toString());
        List<DailyVoucherSummaryReport> redeemsReports = PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, voucherSearcher.getRedeemsQuery().toString());
        List<DailyVoucherSummaryReport> redeemReversalsReports = PersistenceManager.getObjectList(DailyVoucherSummaryReport.class, voucherSearcher.getRedeemReversalsQuery().toString());
        DailyVoucherSummaryReportCompiler compiler = new DailyVoucherSummaryReportCompiler(topupsReports, topupReversalsReports, redeemsReports, redeemReversalsReports);
        super.getParameters().put(VOUCHER_SUMMARY, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder("Voucher Activity Snapshot", false, false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), VOUCHER_SUMMARY, 0, 10);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate voucher top ups/redeems subreport :", (Throwable)ex);
        }
    }

    private void addProductivitySubReport(ReportBuilder superBuilder) {
        DailyProductivitySummaryReportSearcher productivitySearcher = this.searcher.getProductivitySearcher();
        List<DailyProductivitySummaryReport> reports = productivitySearcher.search();
        DailyProductivitySummaryReportCompiler compiler = new DailyProductivitySummaryReportCompiler(this.searcher.getParams().getStart(), this.searcher.getParams().getEnd());
        compiler.compile(reports, this.patrons, this.originalSalesReportList);
        super.getParameters().put(PRODUCTIVITY_SUMMARY, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(this.createSubReportBuilder("Productivity Snapshot", false, false, compiler.getColumnNames()).buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), PRODUCTIVITY_SUMMARY, 0, 10, true);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate productivity subreport :", (Throwable)ex);
        }
    }

    private void addReconciliationSubReport(ReportBuilder superBuilder) {
        ReportBuilder builder = new ReportBuilder();
        builder.setTitle("Reconciliation Snapshot");
        DailyReconciliationSummaryReportSearcher recSearcher = this.searcher.getReconciliationSearcher();
        DailyReconciliationSummaryReportCompiler compiler = new DailyReconciliationSummaryReportCompiler(recSearcher);
        super.getParameters().put(RECONCILIATION_SUMMARY, new JRTableModelDataSource(new GenericBiListTableModel(compiler.getColumnNames(), compiler.getReportData())));
        SimpleColumn groupColumn = null;
        int size = compiler.getColumnNames().size();
        int iPosition = 0;
        for (String name : compiler.getColumnNames()) {
            if (iPosition == 0 || iPosition == 1 || iPosition == size - 1) {
                ColumnProperty prop = new ColumnProperty(name, String.class);
                SimpleColumn column = new SimpleColumn();
                column.setColumnProperty(prop);
                column.setName(name);
                column.setTitle(name);
                builder.getReportBuilder().addColumn((AbstractColumn)column);
                if (column.getName().equals("Cashdrawer")) {
                    groupColumn = column;
                }
                if (iPosition == 0 || iPosition == 1) {
                    column.setHeaderStyle(JasperReportHelper.leftAlignStyle(builder.getStyles().getColumnHeaderStyle()));
                    column.setStyle(JasperReportHelper.leftAlignStyle(builder.getStyles().getColumnDetailStyle()));
                } else {
                    column.setHeaderStyle(JasperReportHelper.rightAlignStyle(builder.getStyles().getColumnHeaderStyle()));
                    column.setStyle(JasperReportHelper.rightAlignStyle(builder.getStyles().getColumnDetailStyle()));
                }
            }
            ++iPosition;
        }
        GroupBuilder groupBuilder = new GroupBuilder();
        groupBuilder.setCriteriaColumn(groupColumn);
        groupBuilder.setGroupLayout(GroupLayout.DEFAULT);
        builder.getReportBuilder().addGroup(groupBuilder.build());
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(builder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), RECONCILIATION_SUMMARY, 0, 10, true);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate reconciliation summary subreport :", (Throwable)ex);
        }
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + DailySummaryReportSearcher.TRADING_DAY_FK_LINK.getOwner().getSimpleName();
    }
}

