/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.staff;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.sales.staff.AbstractStaffSoldReport;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.sales.staff.AbstractStaffSoldReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateDefaultReportStyle;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.printing.HeaderSubReport;

public abstract class AbstractStaffSoldReportProvider<T extends AbstractStaffSoldReport>
extends AbstractReportProvider {
    private User user;
    private PeriodReportAdapter period;
    private ReportBuilder builder;
    private OrderMateDefaultReportStyle reportStyles;
    private AbstractStaffSoldReportSearcher<T> searcher;

    public AbstractStaffSoldReportProvider(AbstractStaffSoldReportSearcher<T> theSearcher) {
        this.searcher = theSearcher;
        this.period = PeriodReportAdapter.DAILY;
        this.reportStyles = new OrderMateOmorphosReportStyle();
    }

    public void configureForPeriod(PeriodReportAdapter newPeriod) {
        this.period = newPeriod;
        this.builder = null;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.searcher.search());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.builder = this.getBuilder();
        return this.builder.buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        if (this.builder == null) {
            this.builder = new ReportBuilder(this.reportStyles);
            this.initBuilder();
        }
        this.builder.setTitle((this.period == null ? "" : this.period.getLabel() + " ") + this.getTitle());
        this.builder.setSubtitle(this.getSubtitle());
        return this.builder;
    }

    private void initBuilder() throws BuilderException {
        this.builder.addBusinessLogoDetailHeaderAndFooterTemplate();
        this.getParameters().putAll(new HeaderSubReport().getParamsMap());
        if (this.user != null) {
            this.addParam("user", this.user.getName());
        }
        this.builder.addReportColumns(Arrays.asList(AbstractStaffSoldReport.Properties.FORMATTED_LABEL, AbstractStaffSoldReport.Properties.FULLNAME, AbstractStaffSoldReport.Properties.QUANTITY, AbstractStaffSoldReport.Properties.TOTAL), "Item Name", "User", "Quantity Sold", "Dollar Value");
        this.builder.getReportBuilder().setPrintBackgroundOnOddRows(false);
        this.builder.getPropertyColumn(AbstractStaffSoldReport.Properties.TOTAL).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        this.builder.addInvisibleField(AbstractStaffSoldReport.Properties.TOTAL_RAW_VALUE);
        this.builder.getPropertyColumn(AbstractStaffSoldReport.Properties.TOTAL_RAW_VALUE).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        this.builder.getPropertyColumn(AbstractStaffSoldReport.Properties.TOTAL_RAW_VALUE).setTitle("Dollar Value");
        ReportBuilder reportBuilder = this.builder;
        reportBuilder.getClass();
        ReportBuilder.PropertyGroupSpec itemGroupSpec = new ReportBuilder.PropertyGroupSpec(reportBuilder, AbstractStaffSoldReport.Properties.FORMATTED_LABEL);
        Style menuGroupStyle = new StyleBuilder(true).setFont(new Font(14, "Arial", true)).build();
        itemGroupSpec.setGroupedColumnStyle(menuGroupStyle);
        DJGroup totalGroupBy = this.builder.addGroupBy(itemGroupSpec, Arrays.asList(new ReportBuilder.PropertyCalculation(AbstractStaffSoldReport.Properties.QUANTITY, DJCalculation.SUM), new ReportBuilder.PropertyCalculation(AbstractStaffSoldReport.Properties.TOTAL, DJCalculation.SUM)));
        DJGroupLabel totalLabel = new DJGroupLabel("Total", this.reportStyles.getFooterVariableStyle(), LabelPosition.LEFT);
        totalGroupBy.setFooterLabel(totalLabel);
        totalGroupBy.setFitFooterHeightToContent(true);
        totalGroupBy.setLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS_AND_COLUMN_NAME);
        PropertyColumn groupCol = this.builder.getPropertyColumn(AbstractStaffSoldReport.Properties.FORMATTED_LABEL);
        this.hideColumnName(groupCol);
        totalGroupBy.setStartInNewPage(Boolean.TRUE);
        ReportBuilder reportBuilder2 = this.builder;
        reportBuilder2.getClass();
        ReportBuilder.PropertyGroupSpec userGroupSpec = new ReportBuilder.PropertyGroupSpec(reportBuilder2, AbstractStaffSoldReport.Properties.FULLNAME);
        DJGroup chartGroup = this.builder.addGroupBy(userGroupSpec, Collections.emptyList());
        chartGroup.setLayout(GroupLayout.VALUE_FOR_EACH);
        this.builder.createBarChart(chartGroup, ReportBuilder.ChartCalculation.SUM, Arrays.asList(this.builder.getPropertyColumn(AbstractStaffSoldReport.Properties.TOTAL_RAW_VALUE)), (byte)1, new DJAxisFormat("Item Sales (" + Internationalization.getLiteralFor("DOLLAR_SIGN") + ")"));
    }

    protected abstract String getTitle();

    protected String getSubtitle() {
        StringBuilder output = new StringBuilder();
        if (this.searcher.getTradingDayFilter().hasSearchValue()) {
            output.append(TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this.searcher));
        }
        if (this.searcher.getTradingDayDateRangeFilter().hasSearchValue()) {
            if (this.period == null) {
                output.append(TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this.searcher));
            } else {
                output.append(this.period.formatTradingDayRangeForDisplay((Date)this.searcher.getTradingDayDateRangeFilter().getStart(), (Date)this.searcher.getTradingDayDateRangeFilter().getEnd(), (Date)this.searcher.getTradingDayDateRangeAdapter().getEnd()));
                output.append(" ");
            }
        }
        if (this.searcher.getTimeFilter().hasSearchValue()) {
            this.getHelper().appendSubTitleAndValue(output, "Day Part", this.searcher.getTimeFilter().getDisplayableTime());
        }
        this.getHelper().appendSearchFilter(output, "Shift", this.searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(output, "User", this.searcher.getUserFilter());
        this.getHelper().appendSearchFilter(output, "Sales Location", this.searcher.getSalesLocationFilter());
        return output.toString();
    }

    public void setUser(User runningUser) {
        this.user = runningUser;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.searcher.getTradingDayDateRangeFilter());
    }
}

