/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.staff.deletion;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.sales.staff.StaffDeletedItemsReport;
import ordermate.database.reports.sales.staff.StaffDeletedItemsReportSummary;
import ordermate.database.reports.staff.deletion.StaffDeletionsReportCompiler;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;
import ordermate.database.searchers.reports.sales.staff.StaffDeletionReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateTimeExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.printing.HeaderSubReport;

public class StaffDeletionReportProvider
extends AbstractReportProvider {
    private PeriodReportAdapter period;
    private StaffDeletionReportSearcher searcher;
    private StaffDeletionsReportCompiler compiler;
    private final ReportBuilder builder = new ReportBuilder(ReportBuilder.TemplateFormat.A4Portrait);
    private static final String DATA = "DATA";

    public StaffDeletionReportProvider(StaffDeletionReportSearcher searcher) {
        this.searcher = searcher;
        this.compiler = new StaffDeletionsReportCompiler();
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        ArrayList deletedList = new ArrayList(this.searcher.search());
        return new JRBeanCollectionDataSource(deletedList);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.addParam(DATA, new JRBeanCollectionDataSource(this.compiler.getResults(this.searcher.search())));
        DynamicReport report = this.getBuilder().buildJasperReport();
        report.setTitle(this.getTitle());
        report.setSubtitle(this.getSubtitle());
        return report;
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        if (this.builder.getColumnCount() == 0) {
            this.initBuilder();
        }
        return this.builder;
    }

    private synchronized void initBuilder() throws BuilderException {
        this.builder.getCustomExpressionRegister().put(Date.class, new DateTimeExpressionBuilder());
        this.builder.addBusinessLogoDetailHeaderAndFooterTemplate();
        this.getParameters().putAll(new HeaderSubReport().getParamsMap());
        this.addParam(DATA, new JRBeanCollectionDataSource(this.compiler.getResults(this.searcher.search())));
        this.builder.setTitle(this.getTitle());
        this.builder.setSubtitle(this.getSubtitle());
        this.builder.addReportColumns(Arrays.asList(StaffDeletedItemsReport.Properties.ORDERED_USER, StaffDeletedItemsReport.Properties.ACCOUNT, StaffDeletedItemsReport.Properties.FORMATTED_LABEL, StaffDeletedItemsReport.Properties.ORDERED_TIME, StaffDeletedItemsReport.Properties.DATE_DELETED, StaffDeletedItemsReport.Properties.DELETED_USER, StaffDeletedItemsReport.Properties.SIZE, StaffDeletedItemsReport.Properties.PORTION, StaffDeletedItemsReport.Properties.QUANTITY, StaffDeletedItemsReport.Properties.TOTAL), "Ordered User", "Account", "Item Name", "Ordered Time", "Deleted Time", "Deleted User", "Size", "Portion", "Quantity", "Total");
        this.builder.getPropertyColumn(StaffDeletedItemsReport.Properties.ACCOUNT).setPattern("0");
        this.builder.getPropertyColumn(StaffDeletedItemsReport.Properties.TOTAL).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        this.builder.getPropertyColumn(StaffDeletedItemsReport.Properties.QUANTITY).setPattern("0");
        ReportBuilder.PropertyCalculation sumMoney = new ReportBuilder.PropertyCalculation(StaffDeletedItemsReport.Properties.TOTAL, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumQty = new ReportBuilder.PropertyCalculation(StaffDeletedItemsReport.Properties.QUANTITY, DJCalculation.SUM);
        DJGroup group = this.builder.addGroupBy(StaffDeletedItemsReport.Properties.ORDERED_USER, Arrays.asList(sumMoney, sumQty));
        DJGroupLabel footerLabel = new DJGroupLabel("Total: ", this.builder.getStyles().getFooterVariableStyle(), LabelPosition.LEFT);
        group.setLayout(GroupLayout.DEFAULT_WITH_HEADER);
        group.setFooterLabel(footerLabel);
        Style groupedColumnStyle = this.builder.getStyles().getGroupedDetailStyle();
        PropertyColumn groupCol = this.builder.getPropertyColumn(StaffDeletedItemsReport.Properties.ORDERED_USER);
        groupCol.setHeaderStyle(groupedColumnStyle);
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setAllowHeaederSplit(false);
        group.setAllowFooterSplit(false);
        group.setHeaderHeight(Integer.valueOf(15));
        this.builder.getReportBuilder().setAllowDetailSplit(true);
        try {
            this.builder.getReportBuilder().addConcatenatedReport(this.generateSummaryReport(), (LayoutManager)new ClassicLayoutManager(), DATA, 0, 10, false);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.warn("Cannot build sub reports", (Throwable)ex);
        }
    }

    private DynamicReport generateSummaryReport() throws BuilderException {
        ReportBuilder dataSubReportBuilder = new ReportBuilder();
        dataSubReportBuilder.addReportColumn(StaffDeletedItemsReportSummary.Properties.FULL_NAME, "User", null);
        dataSubReportBuilder.addReportColumn(StaffDeletedItemsReportSummary.Properties.TOTAL_QTY, "Total Quantity", null);
        dataSubReportBuilder.addReportColumn(StaffDeletedItemsReportSummary.Properties.RAW_TOTAL, "Total Price", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        dataSubReportBuilder.getReportBuilder().setAllowDetailSplit(true);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(StaffDeletedItemsReportSummary.Properties.TOTAL_QTY), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)dataSubReportBuilder.getPropertyColumn(StaffDeletedItemsReportSummary.Properties.RAW_TOTAL), DJCalculation.SUM, null);
        dataSubReportBuilder.getReportBuilder().setGrandTotalLegend("Total Values");
        return dataSubReportBuilder.buildJasperReport();
    }

    private String getTitle() {
        return "Staff Deletion Report";
    }

    private String getSubtitle() {
        StringBuilder output = new StringBuilder();
        if (this.searcher.getTradingDayFilter().hasSearchValue()) {
            output.append(TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this.searcher));
        }
        if (this.searcher.getTradingDayDateRangeAdapter().hasSearchValue()) {
            if (this.period == null) {
                output.append(TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this.searcher));
            } else {
                output.append(this.period.formatTradingDayRangeForDisplay((Date)this.searcher.getTradingDayDateRangeFilter().getStart(), (Date)this.searcher.getTradingDayDateRangeFilter().getEnd(), (Date)this.searcher.getTradingDayDateRangeAdapter().getEnd()));
                output.append(" ");
            }
        }
        if (this.searcher.getTimeFilter().hasSearchValue()) {
            this.getHelper().appendSubTitleAndValue(output, "Day Part", this.searcher.getTimeFilter().getDisplayableTime());
        }
        this.getHelper().appendSearchFilter(output, "Shift", this.searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(output, "User", this.searcher.getUserFilter());
        this.getHelper().appendSearchFilter(output, "Item", this.searcher.getItemSearchFilter());
        this.getHelper().appendSearchFilter(output, "Sales Location", this.searcher.getSalesLocationFilter());
        return output.toString();
    }

    public void gotPeriod(PeriodReportAdapter newPeriod) {
        this.period = newPeriod;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

