/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
public class StockItemPriceReport
extends PersistentSummaryObject {
    private static final Double ZERO = 0.0;
    public static final Props Properties = new Props();
    private String supplier = "No Supplier";
    private String stockItem;
    private String invoiceNumber;
    private Date date;
    private Double received;
    private Price pricePaid = Price.ZERO_DOLLAR;
    private String invoiceSystemState;

    @Column(name="supplier_label")
    public String getSupplier() {
        return this.supplier;
    }

    public void setSupplier(String value) {
        this.supplier = value;
    }

    @Column(name="stock_label")
    public String getStockItem() {
        return this.stockItem;
    }

    public void setStockItem(String value) {
        this.stockItem = value;
    }

    @Column(name="invoice_number")
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String value) {
        this.invoiceNumber = value;
    }

    @Column(name="received")
    public Double getReceived() {
        return this.received;
    }

    public void setReceived(Double value) {
        this.received = value == null ? ZERO : value;
    }

    @Transient
    public Double getPricePerUnit() {
        if (this.getReceived() != 0.0) {
            return this.getPricePaid().divide(this.getReceived()).doubleValue();
        }
        return Price.ZERO_DOLLAR.doubleValue();
    }

    @Column(name="the_date")
    @Temporal(value=TemporalType.DATE)
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date value) {
        this.date = value;
    }

    @Column(name="price_paid")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getPricePaid() {
        return this.pricePaid;
    }

    public void setPricePaid(Price value) {
        this.pricePaid = value;
    }

    @Column(name="invoice_system_state")
    public String getInvoiceSystemState() {
        return this.invoiceSystemState;
    }

    public void setInvoiceSystemState(String value) {
        this.invoiceSystemState = value;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<String> SUPPLIER;
        public PropertiedObject.Property<Double> RECEIVED;
        public PropertiedObject.Property<String> STOCK_ITEM;
        public PropertiedObject.Property<String> INVOICE_NUMBER;
        public PropertiedObject.Property<Date> DATE;
        public PropertiedObject.Property<Price> PRICE_PAID;
        public PersistentObject.DerivedProperty<Double> PRICE_PER_UNIT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)StockItemPriceReport.class), "pricePerUnit");
        public PropertiedObject.Property<String> INVOICE_SYSTEM_STATE;
    }
}

