/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Date;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.reports.stock.StockItemPriceReport;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;

public class StockItemPriceReportSearcher
extends PropertySearcher<StockItemPriceReport> {
    private DateRangeSearchFilter dateRangeFilter;
    private ISingleValueSearchFilter<StockItem> stockFilter;
    private ISingleValueSearchFilter<StockSupplier> supplierFilter;

    public StockItemPriceReportSearcher() {
        super(StockItemPriceReport.class);
        this.dateRangeFilter = new OptimisedDateRangeSearchFilter(StockInvoice.Properties.DATE, SQLDateType.DATE);
        this.stockFilter = new ObjectSearchFilter<StockItem>(StockInvoiceEntry.Properties.STOCK_ITEM);
        this.supplierFilter = new ObjectSearchFilter<StockSupplier>(StockInvoice.Properties.SUPPLIER);
        this.addSearchFilter(this.dateRangeFilter);
        this.addSearchFilter(this.stockFilter);
        this.addSearchFilter(this.supplierFilter);
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return Query.select(StockInvoiceEntry.Properties.ID, "ID").select(StockInvoiceEntry.Properties.STOCK_ITEM, "fk_stock_item").selectFunc("SUM(" + StockInvoiceEntry.Properties.NUM_RECEIVED + " + " + StockInvoiceEntry.Properties.BONUS_RECEIVED + ") AS received").sum(StockInvoiceEntry.Properties.PRICE_PAID, "price_paid").select(StockInvoice.Properties.INVOICE_NUMBER, "invoice_number").select(StockItem.Properties.LABEL, "stock_label").select(StockInvoice.Properties.DATE, "the_date").select(StockSupplier.Properties.LABEL, "supplier_label").select(StockInvoice.Properties.SYSTEM_STATE, "invoice_system_state").linkUsing(StockInvoiceEntry.Properties.INVOICE).linkUsing(StockInvoice.Properties.SUPPLIER).linkUsing(StockInvoiceEntry.Properties.STOCK_ITEM).equals(StockInvoice.Properties.INVOICE_TYPE, "Invoice").groupBy(StockInvoiceEntry.Properties.STOCK_ITEM).groupBy(StockInvoice.Properties.SUPPLIER).groupBy(StockInvoice.Properties.ID).orderBy(StockInvoice.Properties.DATE).orderBy(StockItem.Properties.LABEL);
    }

    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, nullAllowed=false, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public DateRangeSearchFilter getDateRangeFilter() {
        return this.dateRangeFilter;
    }

    @FilterConfig(name="Stock Item", dataType=StockItem.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=2)
    public ISingleValueSearchFilter<StockItem> getStockFilter() {
        return this.stockFilter;
    }

    @FilterConfig(name="Supplier", dataType=StockSupplier.class, nullAllowed=true, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public ISingleValueSearchFilter<StockSupplier> getSupplierFilter() {
        return this.supplierFilter;
    }
}

