/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.adjustment;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.persistence.ArrayObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.reports.stock.adjustment.StockAdjustmentReportQuery;
import ordermate.database.searchers.stock.adjustment.StockAdjustmentSearcher;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class StockAdjustmentReportProvider
extends AbstractReportProvider {
    private StockAdjustmentSearcher searcher;
    private static final int[] colIndex = new int[]{1, 3, 4, 5, 6, 7, 9};

    public StockAdjustmentReportProvider(StockAdjustmentSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        List<ArrayObject> values = this.searcher.search();
        Object[][] data = new Object[values.size()][StockAdjustmentReportQuery.displayColumns.length];
        for (int i = 0; i < values.size(); ++i) {
            Object[] thing = values.get(i).getArray();
            for (int j = 0; j < colIndex.length; ++j) {
                data[i][j] = thing[colIndex[j]];
                if (data[i][j] == null) {
                    data[i][j] = 0.0;
                }
                if (j == 1) {
                    MeasureUnitContainer unitContainer = null;
                    Long measureStringLink = (Long)thing[2];
                    unitContainer = PersistenceManager.getByID(measureStringLink, MeasureUnitContainer.class);
                    Quantity retval = null;
                    Number num = (Number)data[i][j];
                    retval = new Quantity(unitContainer, num.doubleValue(), true);
                    data[i][j] = retval.toString();
                }
                if (j != 6) continue;
                Number num = (Number)data[i][j];
                data[i][j] = new Price(num != null ? num.doubleValue() : 0.0, 0.0).toString();
            }
        }
        DefaultTableModel model = new DefaultTableModel(data, StockAdjustmentReportQuery.displayColumns);
        JRTableModelDataSource source = new JRTableModelDataSource((TableModel)model);
        return source;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle());
        builder.setTitle("Stock On Hand Adjustments");
        StringBuilder subtitle = new StringBuilder(this.searcher.getDateRangeFilter().getStart() + " to " + this.searcher.getDateRangeFilter().getEnd());
        this.getHelper().appendSearchFilter(subtitle, "Stock Area", this.searcher.getStockAreaFilter());
        this.getHelper().appendSearchFilter(subtitle, "User", this.searcher.getUserSearchFilter());
        builder.setSubtitle(subtitle.toString());
        for (int i = 0; i < StockAdjustmentReportQuery.displayColumns.length; ++i) {
            SimpleColumn column = new SimpleColumn();
            column.setName(StockAdjustmentReportQuery.displayColumns[i]);
            column.setTitle(StockAdjustmentReportQuery.displayColumns[i]);
            ColumnProperty prop = i == 2 ? new ColumnProperty(StockAdjustmentReportQuery.displayColumns[i], Date.class) : new ColumnProperty(StockAdjustmentReportQuery.displayColumns[i], String.class);
            column.setColumnProperty(prop);
            builder.getReportBuilder().addColumn((AbstractColumn)column);
        }
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

