/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.adjustment;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import java.text.MessageFormat;
import ordermate.internationalization.Internationalization;

public class StockAdjustmentReportQuery {
    static final String DB_STOCK_USAGE_ID = "stock_usage.ID";
    static final String DB_STOCK_ITEM_NAME = "stock_item.Name";
    static final String DB_STOCK_USAGE_QUANTITY = "-stock_usage.Quantity";
    static final String DB_STOCK_USAGE_DATE = "stock_usage.UsageDate";
    static final String DB_USER_NAME = "UserName";
    static final String DB_STOCK_USAGE_CREATION_DATE = "stock_usage.CreationDate";
    static final String DB_STOCK_ITEM_DISPLAY_UNIT = "stock_item.fk_display_measure_unit_container";
    public static final String DB_STOCK_USAGE_VALUE = "UsageValue";
    public static String[] dbColumns = new String[]{"stock_item.Name", "-stock_usage.Quantity", "stock_usage.UsageDate", "UserName", "stock_area.Name", "Reason", "UsageValue"};
    private static final String GST = Internationalization.getLiteralFor("GST");
    private static final String VALUE_COL_NAME = MessageFormat.format("Value (Inc {0})", GST);
    public static String[] displayColumns = new String[]{"Stock Item", "Quantity", "Date", "User", "Stock Area", "Reason", VALUE_COL_NAME};

    public static SelectQuery doQuery() {
        SelectQuery baseQuery = SQL.createQuery(new String[]{"stock_usage", "stock_item", "config_user", "stock_area", "stock_on_hand"});
        baseQuery.clearWhere();
        baseQuery.addWhere(SQL.join("stock_on_hand", "stock_item"));
        baseQuery.addWhere(SQL.join("stock_on_hand", "stock_area"));
        baseQuery.addWhere(SQL.join("stock_usage", "stock_item"));
        baseQuery.addWhere("stock_usage.FK_stock_area = stock_area.ID");
        baseQuery.addWhere("stock_usage.FK_config_user = config_user.ID");
        baseQuery.addWhere(SQL.isActive("stock_usage"));
        baseQuery.addWhere("stock_usage.usage_state = 'ADJUST'");
        baseQuery.clearSelectValues();
        baseQuery.addSelectValue(DB_STOCK_USAGE_ID);
        baseQuery.addSelectValue(DB_STOCK_ITEM_NAME);
        baseQuery.addSelectValue(DB_STOCK_ITEM_DISPLAY_UNIT);
        baseQuery.addSelectValue(DB_STOCK_USAGE_QUANTITY);
        baseQuery.addSelectValue(DB_STOCK_USAGE_DATE);
        baseQuery.addSelectValue("CONCAT(config_user.FirstName, CONCAT(' ', config_user.Surname)) AS UserName");
        baseQuery.addSelectValue("stock_area.Name");
        baseQuery.addSelectValue("Reason");
        baseQuery.addSelectValue("CreationDate");
        baseQuery.addSelectValue("-HistoricalCost AS UsageValue");
        baseQuery.addOrderBy(DB_STOCK_USAGE_DATE, false);
        baseQuery.addOrderBy(DB_STOCK_USAGE_ID, false);
        return baseQuery;
    }
}

