/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.history;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ChartBuilderException;
import ar.com.fdvs.dj.domain.chart.builder.DJLineChartBuilder;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.stock.StockItemPriceReport;
import ordermate.database.reports.stock.StockItemPriceReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class StockItemHistoryReportProvider
extends AbstractReportProvider {
    private static final double LINE_TILT = -60.0;
    private List<StockItemPriceReport> reports = new ArrayList<StockItemPriceReport>();
    private StockItemPriceReportSearcher searcher;

    public StockItemHistoryReportProvider(StockItemPriceReportSearcher yourSearcher) {
        this.searcher = yourSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.reports = this.searcher.search();
        ArrayList<StockItemPriceReport> toOmit = new ArrayList<StockItemPriceReport>();
        for (StockItemPriceReport report : this.reports) {
            if (!"DELETED".equals(report.getInvoiceSystemState())) continue;
            toOmit.add(report);
        }
        this.reports.removeAll(toOmit);
        return new JRBeanCollectionDataSource(this.reports);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Stock Item Price History");
        StringBuilder SB = new StringBuilder("Stock Item: ");
        SB.append(String.valueOf(this.searcher.getStockFilter().getSearchValue()));
        DateRangeSearchFilter dateFilter = this.searcher.getDateRangeFilter();
        if (dateFilter.getStart() != null && dateFilter.getEnd() != null) {
            SB.append("\\n").append("Date Range: ").append(PeriodReportAdapter.DAILY.formatRangeForDisplay((Date)dateFilter.getStart(), (Date)dateFilter.getEnd()));
        }
        this.getHelper().appendSearchFilter(SB, "Supplier", this.searcher.getSupplierFilter());
        builder.setSubtitle(SB.toString());
        builder.addReportColumn(StockItemPriceReport.Properties.SUPPLIER, "Supplier", null);
        builder.addReportColumn(StockItemPriceReport.Properties.INVOICE_NUMBER, "Invoice Number", null);
        builder.addReportColumn(StockItemPriceReport.Properties.DATE, "Date", "dd/MM/yyyy");
        builder.addReportColumn(StockItemPriceReport.Properties.RECEIVED, "Units Purchased", "0");
        builder.addReportColumn(StockItemPriceReport.Properties.PRICE_PER_UNIT, "Price Per Unit", Internationalization.getLiteralFor("DOLLAR_SIGN") + "#0.00");
        HashSet<ReportBuilder.PropertyCalculation> calcs = new HashSet<ReportBuilder.PropertyCalculation>();
        calcs.add(new ReportBuilder.PropertyCalculation(StockItemPriceReport.Properties.RECEIVED, DJCalculation.SUM));
        calcs.add(new ReportBuilder.PropertyCalculation(StockItemPriceReport.Properties.PRICE_PER_UNIT, DJCalculation.AVERAGE));
        DJGroup group = builder.addGroupBy(StockItemPriceReport.Properties.SUPPLIER, calcs);
        this.addPriceChart(builder);
        this.addReceivedChart(builder);
        return builder;
    }

    private void addPriceChart(ReportBuilder builder) {
        DJLineChartBuilder lineBuilder = new DJLineChartBuilder();
        lineBuilder.setCategory(builder.getPropertyColumn(StockItemPriceReport.Properties.DATE));
        lineBuilder.addSerie((AbstractColumn)builder.getPropertyColumn(StockItemPriceReport.Properties.PRICE_PER_UNIT), Internationalization.getLiteralFor("DOLLAR_SIGN") + " Per Unit");
        lineBuilder.setLabelRotation(-60.0);
        try {
            builder.addChart(lineBuilder.build());
        }
        catch (ChartBuilderException ex) {
            OrderMate.LOG.error("Cannot builder chart for StockItemHistory:", (Throwable)ex);
        }
    }

    private void addReceivedChart(ReportBuilder builder) {
        DJLineChartBuilder lineBuilder = new DJLineChartBuilder();
        lineBuilder.setCategory(builder.getPropertyColumn(StockItemPriceReport.Properties.DATE));
        lineBuilder.addSerie((AbstractColumn)builder.getPropertyColumn(StockItemPriceReport.Properties.RECEIVED), "Purchased");
        lineBuilder.addSeriesColor(Color.BLUE);
        lineBuilder.setLabelRotation(-60.0);
        try {
            builder.addChart(lineBuilder.build());
        }
        catch (ChartBuilderException ex) {
            OrderMate.LOG.error("Cannot builder chart for StockItemHistory:", (Throwable)ex);
        }
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

