/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.ingredients;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.ItemStockIngredientsReport;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.stock.ingredients.ItemStockIngredientsReportSearcher;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.dynamicjasper.reportbuilder.DataSourceProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class ItemStockIngredientsReportProvider
extends AbstractReportProvider {
    private final DataSourceProvider provider;
    private final ReportBuilder builder;
    private ItemStockIngredientsReportSearcher searcher;
    private User user;
    private static List<ReportBuilder.PropertyCalculation> COST_SUM = Arrays.asList(new ReportBuilder.PropertyCalculation(ItemStockIngredientsReport.Properties.COST, DJCalculation.SUM));

    public ItemStockIngredientsReportProvider(ItemStockIngredientsReportSearcher aSearcher) {
        this.searcher = aSearcher;
        this.provider = new SearcherDataSourceProvider<ItemStockIngredientsReportSearcher>(this.searcher);
        this.builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.provider.getDataSource();
    }

    @Override
    public synchronized ReportBuilder getBuilder() throws BuilderException {
        if (this.builder.getColumnCount() == 0) {
            this.initBuilder();
        }
        return this.builder;
    }

    private synchronized void initBuilder() throws BuilderException {
        this.builder.setTitle("Item Ingredients Stock Report");
        this.builder.setSubtitle(this.getSubtitle());
        this.getParameters().putAll(this.builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        if (this.user != null) {
            this.addParam("user", this.user.getName());
        }
        this.builder.addReportColumns(Arrays.asList(ItemStockIngredientsReport.Properties.INVENTORY_GROUP_FULL, ItemStockIngredientsReport.Properties.REPORT_NAME, ItemStockIngredientsReport.Properties.STOCK_NAME, ItemStockIngredientsReport.Properties.REPORT_QTY, ItemStockIngredientsReport.Properties.COST), "Menu Group", "Sales Item (Size, Portion)", "Ingredient Name", "Quantity", "Current Ingredient Cost");
        this.builder.getReportBuilder().setPrintBackgroundOnOddRows(false);
        this.builder.getPropertyColumn(ItemStockIngredientsReport.Properties.COST).setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        Style rightAlign = JasperReportHelper.rightAlignStyle(this.builder.getStyles().getColumnDetailStyle());
        Style indentStockName = new StyleBuilder(true).setPaddingLeft(Integer.valueOf(20)).setFont(this.getBuilder().getStyles().getColumnDetailStyle().getFont()).build();
        this.builder.getPropertyColumn(ItemStockIngredientsReport.Properties.STOCK_NAME).setStyle(indentStockName);
        ReportBuilder reportBuilder = this.builder;
        reportBuilder.getClass();
        ReportBuilder.PropertyGroupSpec inventoryGroupSpec = new ReportBuilder.PropertyGroupSpec(reportBuilder, ItemStockIngredientsReport.Properties.INVENTORY_GROUP_FULL);
        Style menuGroupStyle = new StyleBuilder(true).setFont(new Font(14, "Arial", true)).build();
        inventoryGroupSpec.setGroupedColumnStyle(menuGroupStyle);
        DJGroup inventoryGroupBy = this.builder.addGroupBy(inventoryGroupSpec, null);
        inventoryGroupBy.setLayout(GroupLayout.VALUE_IN_HEADER_WITH_HEADERS);
        DJGroup itemUnitGroupBy = this.builder.addGroupBy(ItemStockIngredientsReport.Properties.REPORT_NAME, COST_SUM);
        itemUnitGroupBy.setLayout(GroupLayout.VALUE_IN_HEADER);
        itemUnitGroupBy.setFooterLabel(new DJGroupLabel("Item Total", rightAlign, LabelPosition.LEFT));
    }

    private String getSubtitle() {
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendSearchFilter(SB, "Section", this.searcher.getInventoryGroupFilter());
        this.getHelper().appendSearchFilter(SB, "Profile", this.searcher.getInventoryProfileFilter());
        return SB.toString();
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

