/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.ingredients;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.TreeNodeChildSearchFilter;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.Collections;
import java.util.List;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.queries.ItemStockIngredientsQueries;
import ordermate.database.reports.ItemStockIngredientsReport;

public class ItemStockIngredientsReportSearcher
extends PropertySearcher<ItemStockIngredientsReport> {
    private final ObjectQuery query;
    private final TreeNodeChildSearchFilter<InventoryGroup> inventoryGroupFilter;
    private final ObjectJoinSearchFilter inventoryProfileFilter;

    private ItemStockIngredientsReportSearcher(ObjectQuery baseQuery) {
        super(ItemStockIngredientsReport.class);
        this.inventoryGroupFilter = new TreeNodeChildSearchFilter<InventoryGroup>(InventoryItem.Properties.MENU_GROUP);
        this.inventoryProfileFilter = new ObjectJoinSearchFilter<InventoryProfile>(new PropertiedObject.Property[]{InventoryItem.Properties.MENU_GROUP}, new ObjectSearchFilter<InventoryProfile>(InventoryGroup.Properties.PROFILE));
        this.query = baseQuery;
    }

    public ItemStockIngredientsReportSearcher() {
        this(new ObjectQuery());
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        return this.query.copy();
    }

    @FilterConfig(name="Section", dataType=InventoryGroup.class, plural=FilterConfig.Plural.Single, nullAllowed=true, priority=true, sequence=2)
    public TreeNodeChildSearchFilter<InventoryGroup> getInventoryGroupFilter() {
        this.addSearchFilter(this.inventoryGroupFilter);
        return this.inventoryGroupFilter;
    }

    @FilterConfig(name="Profile", defaultValue="1", dataType=InventoryProfile.class, plural=FilterConfig.Plural.Single, nullAllowed=false, priority=true, sequence=1)
    public ISingleValueSearchFilter<InventoryProfile> getInventoryProfileFilter() {
        this.addSearchFilter(this.inventoryProfileFilter);
        return this.inventoryProfileFilter;
    }

    @Override
    public List<ItemStockIngredientsReport> search() {
        ItemStockIngredientsReportSearcher itemStockSearch = new ItemStockIngredientsReportSearcher(ItemStockIngredientsQueries.inventoryItemStockQuery());
        itemStockSearch.addSearchFilter(this.inventoryGroupFilter);
        itemStockSearch.addSearchFilter(this.inventoryProfileFilter);
        ItemStockIngredientsReportSearcher itemManualSearch = new ItemStockIngredientsReportSearcher(ItemStockIngredientsQueries.inventoryItemsWithManualStockCost());
        itemManualSearch.addSearchFilter(this.inventoryGroupFilter);
        itemManualSearch.addSearchFilter(this.inventoryProfileFilter);
        List<ItemStockIngredientsReport> report = PersistenceManager.getObjectList(itemStockSearch);
        report.addAll(PersistenceManager.getObjectList(itemManualSearch));
        Collections.sort(report);
        return report;
    }
}

