/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.onhand;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJValueFormatter;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.GroupBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.persistence.PersistenceManager;
import java.text.Format;
import java.text.NumberFormat;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.Quantity;
import ordermate.database.queries.stock.StockOnHandQueries;
import ordermate.database.reports.stock.onhand.StockOnHandSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.PriceExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class StockOnHandReportProvider
extends AbstractReportProvider {
    private StockOnHandSearcher searcher;

    public StockOnHandReportProvider(StockOnHandSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery(this.searcher.getQuery().toString(), null);
        DefaultTableModel model = new DefaultTableModel(results, StockOnHandQueries.Reports.DISPLAY_COLUMNS);
        int[] dbCols = StockOnHandQueries.Reports.COLUMNS_TO_SHOW;
        for (int col = 0; col < model.getColumnCount(); ++col) {
            for (int row = 0; row < model.getRowCount(); ++row) {
                MeasureUnitContainer unitContainer;
                Long measureFk;
                int mappedCol = dbCols[col];
                Object value = results[row][mappedCol];
                if (mappedCol == 6 || mappedCol == 8) {
                    measureFk = (Long)results[row][3];
                    unitContainer = PersistenceManager.getByID(measureFk, MeasureUnitContainer.class);
                    double avgCost = (Double)value;
                    double qty = (Double)results[row][4];
                    double displayQty = new Quantity(unitContainer, qty, true).doubleValue();
                    value = avgCost / displayQty;
                } else if (mappedCol == 5) {
                    measureFk = (Long)results[row][3];
                    unitContainer = PersistenceManager.getByID(measureFk, MeasureUnitContainer.class);
                    value = new Quantity(unitContainer, (double)((Double)value), true).toString();
                }
                model.setValueAt(value, row, col);
            }
        }
        return new JRTableModelDataSource((TableModel)model);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        OrderMateMinimalistStyle style = new OrderMateMinimalistStyle();
        ReportBuilder builder = new ReportBuilder(style);
        builder.setTitle("Stock On Hand");
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendSearchFilter(SB, "Stock Area", this.searcher.getAreaFilter());
        this.getHelper().appendSearchFilter(SB, "Stock Groups", this.searcher.getGroupFilter());
        builder.setSubtitle(SB.toString());
        String[] colTitles = StockOnHandQueries.Reports.DISPLAY_COLUMNS;
        for (int i = 0; i < colTitles.length; ++i) {
            ColumnProperty prop;
            String colTitle = colTitles[i];
            SimpleColumn column = new SimpleColumn();
            column.setTitle(colTitle);
            column.setName(colTitle);
            builder.getReportBuilder().addColumn((AbstractColumn)column);
            if (i > 2) {
                prop = new ColumnProperty(colTitles[i], Double.class);
                column.setTextFormatter((Format)NumberFormat.getCurrencyInstance());
                column.setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
                if (i > 4) {
                    builder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)column, DJCalculation.SUM, style.getFooterVariableStyle(), new PriceExpressionBuilder.DJPriceFormatter());
                }
            } else {
                prop = new ColumnProperty(colTitles[i], String.class);
            }
            column.setColumnProperty(prop);
        }
        if (Boolean.TRUE.equals(this.searcher.getGroupedFilter().getSearchValue())) {
            GroupBuilder groupBuilder = new GroupBuilder();
            groupBuilder.setCriteriaColumn((PropertyColumn)builder.getReportBuilder().getColumn(0));
            groupBuilder.addFooterVariable(builder.getReportBuilder().getColumn(5), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
            groupBuilder.addFooterVariable(builder.getReportBuilder().getColumn(6), DJCalculation.SUM, style.getFooterVariableStyle(), (DJValueFormatter)new PriceExpressionBuilder.DJPriceFormatter());
            builder.getReportBuilder().addGroup(groupBuilder.build());
        }
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

