/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.onhand;

import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.abstracts.SingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.sql.queries.SelectQuery;
import ordermate.database.queries.stock.StockOnHandQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;

public class StockOnHandSearcher {
    private SingleValueSearchFilter areaFilter;
    private BooleanSearchFilter groupedFilter;
    private MultiOptionSearchFilter groupFilter = new MultiOptionSearchFilter(null);

    public StockOnHandSearcher() {
        this.areaFilter = new ObjectSearchFilter(null);
        this.groupedFilter = new BooleanSearchFilter(null);
    }

    public SelectQuery getQuery() {
        SelectQuery query = StockOnHandQueries.Reports.GetStockOnHandDetail.getQuery((StockArea)this.areaFilter.getSearchValue(), this.groupFilter.getSelectedOptions(), null);
        if (Boolean.TRUE.equals(this.groupedFilter.getSearchValue())) {
            query.clearOrderBy();
            query.addOrderBy("stock_group.Name");
            query.addOrderBy("stock_item.Name");
        }
        return query;
    }

    @FilterConfig(name="Stock Area", dataType=StockArea.class, plural=FilterConfig.Plural.Single, priority=true, sequence=1)
    public SingleValueSearchFilter getAreaFilter() {
        return this.areaFilter;
    }

    @FilterConfig(name="Grouped", dataType=Boolean.class, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public BooleanSearchFilter getGroupedFilter() {
        return this.groupedFilter;
    }

    @FilterConfig(name="Stock Groups", dataType=StockGroup.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=true, sequence=2)
    public MultiOptionSearchFilter getGroupFilter() {
        return this.groupFilter;
    }
}

