/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.transfer;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;

public class StockTransfersReportQuery {
    static final String DB_STOCK_USAGE_ID = "stock_usage.ID";
    static final String DB_STOCK_ITEM_NAME = "stock_item.Name";
    static final String DB_STOCK_USAGE_QUANTITY = "stock_usage.Quantity";
    static final String DB_STOCK_USAGE_DATE = "stock_usage.UsageDate";
    static final String DB_STOCK_USAGE_CREATION_DATE = "stock_usage.CreationDate";
    static final String DB_STOCK_ITEM_DISPLAY_UNIT = "stock_item.fk_display_measure_unit_container";
    static final String DB_STOCK_USAGE_VALUE = "UsageValue";
    public static String[] dbColumns = new String[]{"stock_item.Name", "stock_usage.Quantity", "stock_usage.UsageDate", "area_from.Name", "area_to.Name", "Reason", "UsageValue"};
    public static String[] displayColumns = new String[]{"Stock Item", "Quantity", "Date", "Transfer From", "Transfer To", "Reason", "Value"};

    public static SelectQuery doQuery() {
        SelectQuery baseQuery = SQL.createQuery(new String[]{"stock_usage", "stock_item", "stock_on_hand", "stock_area AS area_from", "stock_area AS area_to"});
        baseQuery.clearWhere();
        baseQuery.addWhere(SQL.join("stock_on_hand", "stock_item"));
        baseQuery.addWhere("stock_on_hand.FK_stock_area = area_from.ID ");
        baseQuery.addWhere(SQL.join("stock_usage", "stock_item"));
        baseQuery.addWhere("stock_usage.FK_stock_area = area_from.ID");
        baseQuery.addWhere("stock_usage.FK_stock_area_transfer_to = area_to.ID");
        baseQuery.addWhere(SQL.isActive("stock_usage"));
        baseQuery.addWhere("stock_usage.usage_state = 'TRANSFER'");
        baseQuery.clearSelectValues();
        baseQuery.addSelectValue(DB_STOCK_USAGE_ID);
        baseQuery.addSelectValue(DB_STOCK_ITEM_NAME);
        baseQuery.addSelectValue(DB_STOCK_ITEM_DISPLAY_UNIT);
        baseQuery.addSelectValue(DB_STOCK_USAGE_QUANTITY);
        baseQuery.addSelectValue(DB_STOCK_USAGE_DATE);
        baseQuery.addSelectValue("area_from.Name");
        baseQuery.addSelectValue("area_to.Name");
        baseQuery.addSelectValue("Reason");
        baseQuery.addSelectValue("CreationDate");
        baseQuery.addSelectValue("-HistoricalCost AS UsageValue");
        baseQuery.addOrderBy(DB_STOCK_USAGE_DATE, false);
        baseQuery.addOrderBy(DB_STOCK_USAGE_ID, false);
        return baseQuery;
    }
}

