/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.usage;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.persistence.ArrayObject;
import java.text.Format;
import java.text.NumberFormat;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.reports.stock.usage.StockUsageReportQuery;
import ordermate.database.reports.stock.usage.StockUsageReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class StockUsageReportProvider
extends AbstractReportProvider {
    private StockUsageReportSearcher searcher;
    private static final int[] colIndex = new int[]{3, 0, 6, 7, 8, 9, 10, 13, 14, 11, 12};

    public StockUsageReportProvider(StockUsageReportSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        List<ArrayObject> values = this.searcher.search();
        Object[][] data = new Object[values.size()][StockUsageReportQuery.displayColumns.length];
        for (int i = 0; i < values.size(); ++i) {
            Object[] thing = values.get(i).getArray();
            for (int j = 0; j < colIndex.length; ++j) {
                data[i][j] = thing[colIndex[j]];
                if (data[i][j] == null) {
                    data[i][j] = 0.0;
                }
                if (j != 6 && j != 8) continue;
                data[i][j] = (Double)data[i][j] / 100.0;
            }
        }
        DefaultTableModel model = new DefaultTableModel(data, StockUsageReportQuery.displayColumns);
        JRTableModelDataSource source = new JRTableModelDataSource((TableModel)model);
        return source;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle());
        builder.setTitle("Stock Usage");
        StringBuilder subtitle = new StringBuilder(this.searcher.getDateRangeFilter().getStart() + " to " + this.searcher.getDateRangeFilter().getEnd());
        this.getHelper().appendSearchFilter(subtitle, "Stock Area", this.searcher.getAreaFilter());
        this.getHelper().appendSearchFilter(subtitle, "Stock Group", this.searcher.getGroupFilter());
        builder.setSubtitle(subtitle.toString());
        for (int i = 0; i < StockUsageReportQuery.displayColumns.length; ++i) {
            SimpleColumn column = new SimpleColumn();
            column.setName(StockUsageReportQuery.displayColumns[i]);
            column.setTitle(StockUsageReportQuery.displayColumns[i]);
            ColumnProperty prop = i > 1 ? new ColumnProperty(StockUsageReportQuery.displayColumns[i], Double.class) : new ColumnProperty(StockUsageReportQuery.displayColumns[i], String.class);
            column.setColumnProperty(prop);
            if (i == 6 || i == 8) {
                column.setTextFormatter((Format)NumberFormat.getPercentInstance());
            } else if (i == 7 || i == 10) {
                column.setTextFormatter((Format)NumberFormat.getCurrencyInstance());
                column.setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            }
            builder.getReportBuilder().addColumn((AbstractColumn)column);
        }
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

