/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.usage;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import java.text.MessageFormat;
import ordermate.database.misc.SystemProperty;
import ordermate.internationalization.Internationalization;

public class StockUsageReportQuery {
    public static final String DISPLAYLABEL_GROUP = "Group";
    public static final String DISPLAYLABEL_COST = MessageFormat.format("{0} (Ex {1})", "COGS", Internationalization.getLiteralFor("GST"));
    public static final String DB_ITEM_ID = "stock_item.ID";
    public static final String DB_ITEM_NAME = "stock_item.Name";
    public static final String DB_ITEM_QTY = "stock_item.Quantity";
    public static final String DB_GROUP_NAME = "stock_group.Name";
    public static final String DB_ITEM_STATE = "stock_item.system_state";
    public static final String DB_ITEM_DISPLAY_MEASURE = "stock_item.DisplayMeasureUnit";
    public static final String DB_ITEM_USAGE = "ItemUsage";
    public static final String DB_ITEM_WASTAGE = "ItemWastage";
    public static final String DB_ITEM_SOLD = "ItemSold";
    public static final String DB_ITEM_PREPROD = "ItemPreProd";
    public static final String DB_ITEM_WASTE_PERCENT = "WastePercent";
    public static final String DB_ITEM_USAGE_COST = "UsageCost";
    public static final String DB_ITEM_ADJUST = "ItemAdjust";
    public static final String DB_YIELD_LOSS = "YieldLoss";
    public static final String DB_YIELD_LOSS_PERCENT = "YieldLossPercent";
    private static final String DB_ITEM_USAGE_COST_FORMULA = "SUM(IF(stock_item.replacement_cost_match_pre_prod, stock_usage.HistoricalCost * " + SystemProperty.getInstance().getBaseTaxFactor() + ", IF(stock_item.tax_included, stock_usage.HistoricalCost * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_usage.HistoricalCost)))";
    public static final String[] dbColumns = new String[]{"stock_group.Name", "stock_item.Name", "ItemUsage", "ItemSold", "ItemPreProd", "ItemWastage", "WastePercent", "YieldLoss", "YieldLossPercent", "ItemAdjust", "UsageCost"};
    public static final String[] displayColumns = new String[]{"Group", "Stock Item", "Total Qty Used", "Qty Sold", "Qty Pre Prod", "Qty Wasted", "Waste %", "Yield Loss", "Yield Loss %", "Qty Adjusted", DISPLAYLABEL_COST};

    public static SelectQuery doQuery() {
        SelectQuery query = SQL.createQuery(new String[]{"stock_item", "stock_group", "stock_usage"});
        query.addSelectValue(DB_ITEM_NAME);
        query.addSelectValue(DB_ITEM_ID);
        query.addSelectValue(DB_ITEM_STATE);
        query.addSelectValue(DB_GROUP_NAME);
        query.addSelectValue(DB_ITEM_DISPLAY_MEASURE);
        query.addSelectValue(DB_ITEM_QTY);
        query.addSelectValue("SUM(IF(stock_usage.usage_state = 'NORMAL' OR stock_usage.usage_state = 'WASTED' OR stock_usage.usage_state = 'YIELD', stock_usage.Quantity, 0)) AS ItemUsage");
        query.addSelectValue("SUM(IF(stock_usage.usage_state = 'NORMAL' AND class_type IS NULL, stock_usage.Quantity, 0)) AS ItemSold");
        query.addSelectValue("SUM(IF(stock_usage.usage_state = 'NORMAL' AND class_type = 'PRE_PROD_CONSUME', stock_usage.Quantity, 0)) AS ItemPreProd");
        query.addSelectValue("SUM(IF(stock_usage.usage_state = 'WASTED', stock_usage.Quantity, 0)) AS ItemWastage");
        query.addSelectValue("100*SUM(IF(stock_usage.usage_state = 'WASTED', stock_usage.Quantity, 0)) / SUM(IF(stock_usage.usage_state = 'NORMAL' OR stock_usage.usage_state = 'WASTED' OR stock_usage.usage_state = 'YIELD', stock_usage.Quantity, 0))  AS WastePercent");
        query.addSelectValue("SUM(IF(stock_usage.usage_state <> 'NORMAL' AND stock_usage.usage_state <> 'WASTED' AND stock_usage.usage_state <> 'YIELD', stock_usage.Quantity, 0)) AS ItemAdjust");
        query.addSelectValue(DB_ITEM_USAGE_COST_FORMULA + "AS " + DB_ITEM_USAGE_COST);
        query.addSelectValue("SUM(IF(stock_usage.usage_state = 'YIELD', stock_usage.Quantity, 0)) AS YieldLoss");
        query.addSelectValue("100*SUM(IF(stock_usage.usage_state = 'YIELD', stock_usage.Quantity, 0)) / SUM(IF(stock_usage.usage_state = 'NORMAL' OR stock_usage.usage_state = 'WASTED' OR stock_usage.usage_state = 'YIELD', stock_usage.Quantity, 0))  AS YieldLossPercent");
        query.addGroupBy(DB_ITEM_ID);
        query.addOrderBy(DB_ITEM_NAME, true);
        StockUsageReportQuery.addWheresToQuery(query);
        return query;
    }

    private static void addWheresToQuery(SelectQuery query) {
        query.clearWhere();
        query.addWhere(SQL.join("stock_usage", "stock_item", "stock_group"));
        query.addWhere(SQL.isActive("stock_usage"));
    }
}

