/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stock.usage;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.ObjectQuerySQLAdapter;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.implementation.DateRangeSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.search.filter.BooleanSearchFilter;
import au.com.ordermate.sql.queries.SelectQuery;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.reports.stock.usage.StockUsageReportQuery;
import ordermate.database.searchers.ArrayObjectSearcher;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;

public class StockUsageReportSearcher
extends ArrayObjectSearcher {
    private DateRangeSearchFilter dateFilter = new DateRangeSearchFilter(null, SQLDateType.TIMESTAMP);
    private ISingleValueSearchFilter<StockArea> areaFilter = new ObjectSearchFilter<StockArea>(null);
    private ISingleValueSearchFilter<StockGroup> groupFilter = new ObjectSearchFilter<StockGroup>(null);
    private BooleanSearchFilter groupedFilter = new BooleanSearchFilter(null);

    public SelectQuery getQuery() {
        SelectQuery query = StockUsageReportQuery.doQuery();
        this.applyFilters(query);
        return query;
    }

    @Override
    protected ObjectQuery createBaseQuery() {
        return new ObjectQuerySQLAdapter(this.getQuery().getSQL());
    }

    @Override
    protected List<String> createStaticColumns() {
        return Arrays.asList(StockUsageReportQuery.displayColumns);
    }

    private void applyFilters(SelectQuery query) {
        if (this.groupFilter.hasSearchValue()) {
            StockGroup group = this.groupFilter.getSearchValue();
            List<StockGroup> allChildren = group.getRecursiveSubGroups();
            String[] conditions = new String[allChildren.size() + 1];
            conditions[0] = "stock_group.ID = " + group.getID();
            for (int i = 0; i < allChildren.size(); ++i) {
                StockGroup child = allChildren.get(i);
                conditions[i + 1] = "stock_group.ID = " + child.getID();
            }
            query.addWhereOr(conditions);
        }
        if (this.areaFilter.hasSearchValue()) {
            query.addWhere("stock_usage.FK_stock_area = " + this.areaFilter.getSearchValue().getID());
        }
        Timestamp sqlFrom = new Timestamp(((Date)this.dateFilter.getStart()).getTime());
        Timestamp sqlTo = new Timestamp(((Date)this.dateFilter.getEnd()).getTime());
        query.addWhere("stock_usage.UsageDate > '" + sqlFrom + "'");
        query.addWhere("stock_usage.UsageDate < '" + sqlTo + "'");
        if (this.isGrouped()) {
            query.clearOrderBy();
            query.addOrderBy("stock_group.Name");
            query.addOrderBy("stock_item.Name");
        }
    }

    @FilterConfig(name="Date Range", defaultValue="DateRange", dataType=Date.class, dateType=SQLDateType.TIMESTAMP, nullAllowed=false, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public DateRangeSearchFilter getDateRangeFilter() {
        return this.dateFilter;
    }

    @FilterConfig(name="Stock Area", dataType=StockArea.class, plural=FilterConfig.Plural.Single, priority=true, sequence=4)
    public ISingleValueSearchFilter<StockArea> getAreaFilter() {
        return this.areaFilter;
    }

    @FilterConfig(name="Stock Group", dataType=StockGroup.class, plural=FilterConfig.Plural.Single, priority=true, sequence=2)
    public ISingleValueSearchFilter<StockGroup> getGroupFilter() {
        return this.groupFilter;
    }

    @FilterConfig(name="Grouped", dataType=Boolean.class, plural=FilterConfig.Plural.Single, priority=true, sequence=3)
    public BooleanSearchFilter getGroupedFilter() {
        return this.groupedFilter;
    }

    public boolean isGrouped() {
        return Boolean.TRUE.equals(this.groupedFilter.getSearchValue());
    }
}

