/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stocktake;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.stocktake.StockTakeView;
import ordermate.database.searchers.stock.stocktake.StockTakeAggregateType;
import ordermate.database.searchers.stock.stocktake.StockTakeSearcher;
import ordermate.database.stock.StockTakeEntry;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class StockTakeReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider<StockTakeSearcher> datasource;
    private boolean showExpectedColumn;
    private StockTakeView view = StockTakeView.NORMAL_VIEW;

    public StockTakeReportProvider(boolean showExpected, StockTakeView view, StockTakeSearcher searcher) {
        this.datasource = new SearcherDataSourceProvider<StockTakeSearcher>(searcher);
        this.view = view;
        this.showExpectedColumn = showExpected;
    }

    public void setShowExpectedColumn(boolean showExpectedColumn) {
        this.showExpectedColumn = showExpectedColumn;
    }

    public void setView(StockTakeView view) {
        this.view = view;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.datasource.getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        ReportBuilder reportBuilder = this.getBuilder();
        StockTakeSearcher searcher = this.datasource.getSearch();
        reportBuilder.setTitle(this.getTitle(searcher));
        reportBuilder.setSubtitle(this.getSubtitle(searcher));
        return reportBuilder.buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        return this.initBuilder();
    }

    protected ReportBuilder initBuilder() throws ColumnBuilderException {
        HashSet<PropertiedObject.Property> invalidSet = new HashSet<PropertiedObject.Property>();
        for (PropertiedObject.Property prop : this.view.getInvalidProperties()) {
            invalidSet.add(prop);
        }
        ReportBuilder reportBuilder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(reportBuilder.addBusinessLogoDetailHeaderAndFooterTemplate());
        this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.STOCK_GROUP, "Stock Group");
        this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.STOCK_ITEM, "Stock Item");
        this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.STOCK_AREA, "Area");
        if (this.showExpectedColumn) {
            this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.EXPECTED_QUANTITY, "Expected Qty");
        }
        this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.OUTER_QTY_AS_QTY, "Outer Qty");
        this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.UNIT_QTY_AS_QTY, "Unit Qty");
        this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.ACTUAL_QUANTITY, "Actual Qty");
        this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE, "Valuation inc");
        this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE_EX, "Valuation ex");
        if (this.showExpectedColumn) {
            this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.VARIANCE, "Variance");
            this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.VARIANCE_COST, "Variance inc");
            this.addPropertyColumn(reportBuilder, invalidSet, StockTakeEntry.Properties.VARIANCE_COST_EX, "Variance ex");
        }
        ArrayList<ReportBuilder.PropertyCalculation> propCalcs = new ArrayList<ReportBuilder.PropertyCalculation>(){
            {
                this.add(new ReportBuilder.PropertyCalculation(StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE, DJCalculation.SUM));
                this.add(new ReportBuilder.PropertyCalculation(StockTakeEntry.Properties.TOTAL_ACTUAL_VALUE_EX, DJCalculation.SUM));
            }
        };
        if (this.showExpectedColumn) {
            propCalcs.add(new ReportBuilder.PropertyCalculation(StockTakeEntry.Properties.VARIANCE_COST, DJCalculation.SUM));
            propCalcs.add(new ReportBuilder.PropertyCalculation(StockTakeEntry.Properties.VARIANCE_COST_EX, DJCalculation.SUM));
        }
        if (!invalidSet.contains(StockTakeEntry.Properties.STOCK_GROUP) && !StockTakeAggregateType.Group.equals((Object)this.view.getAggregateType())) {
            ReportBuilder.GroupSpec groupSpec = new ReportBuilder.GroupSpec(reportBuilder.getPropertyColumn(StockTakeEntry.Properties.STOCK_GROUP)).setShowColumnNames(true).setLayout(GroupLayout.VALUE_IN_HEADER);
            reportBuilder.addGroupBy(groupSpec, (Collection<ReportBuilder.PropertyCalculation>)propCalcs);
        }
        reportBuilder.setUseGrandTotal(true);
        for (ReportBuilder.PropertyCalculation propCalc : propCalcs) {
            reportBuilder.addFooterCalculation(propCalc);
        }
        return reportBuilder;
    }

    private void addPropertyColumn(ReportBuilder builder, Collection<PropertiedObject.Property> invalidSet, PropertiedObject.Property prop, String title) throws ColumnBuilderException {
        if (!invalidSet.contains(prop)) {
            builder.addReportColumn(prop, title, null);
        }
    }

    private String getTitle(StockTakeSearcher searcher) {
        return "Stock Take Report: " + searcher.getStockTakeSearch().getSearchValue();
    }

    private String getSubtitle(StockTakeSearcher searcher) {
        StringBuilder SB = new StringBuilder();
        String area = searcher.getStockAreaSearch().getSearchValue() == null ? "All" : searcher.getStockAreaSearch().getSearchValue().toString();
        this.getHelper().appendSubTitleAndValue(SB, "Area", area);
        this.getHelper().appendSearchFilter(SB, "Group", searcher.getStockGroupSearch());
        return SB.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

