/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.stocktake;

import ordermate.database.reports.stocktake.StockTakeView;
import ordermate.database.searchers.stock.stocktake.StockTakeAggregateType;
import ordermate.database.stock.StockTakeEntry;

public class StockTakeViewFactory {
    public StockTakeView makeView(StockTakeAggregateType type) {
        StockTakeView view;
        switch (type) {
            case None: {
                view = this.makeNoneType();
                break;
            }
            case Item: {
                view = this.makeItemType();
                break;
            }
            case Group: {
                view = this.makeGroupType();
                break;
            }
            case Area: {
                view = this.makeAreaType();
                break;
            }
            case GroupAndArea: {
                view = this.makeGroupAreaType();
                break;
            }
            default: {
                view = this.makeNoneType();
            }
        }
        return view;
    }

    private StockTakeView makeItemType() {
        return new StockTakeView(StockTakeAggregateType.Item, "Aggregated to the Stock Item", StockTakeEntry.Properties.STOCK_AREA);
    }

    private StockTakeView makeGroupType() {
        return new StockTakeView(StockTakeAggregateType.Group, "Aggregated to the Stock Group", StockTakeEntry.Properties.STOCK_AREA, StockTakeEntry.Properties.VARIANCE, StockTakeEntry.Properties.EXPECTED_QUANTITY, StockTakeEntry.Properties.ACTUAL_QUANTITY, StockTakeEntry.Properties.OUTER_QTY, StockTakeEntry.Properties.OUTER_QTY_AS_QTY, StockTakeEntry.Properties.UNIT_QTY, StockTakeEntry.Properties.UNIT_QTY_AS_QTY);
    }

    private StockTakeView makeAreaType() {
        return new StockTakeView(StockTakeAggregateType.Area, "Aggregated to the Stock Area", StockTakeEntry.Properties.STOCK_ITEM, StockTakeEntry.Properties.STOCK_GROUP, StockTakeEntry.Properties.VARIANCE, StockTakeEntry.Properties.EXPECTED_QUANTITY, StockTakeEntry.Properties.ACTUAL_QUANTITY, StockTakeEntry.Properties.OUTER_QTY, StockTakeEntry.Properties.OUTER_QTY_AS_QTY, StockTakeEntry.Properties.UNIT_QTY, StockTakeEntry.Properties.UNIT_QTY_AS_QTY);
    }

    private StockTakeView makeGroupAreaType() {
        return new StockTakeView(StockTakeAggregateType.GroupAndArea, "Aggregated to the Stock Group and Area", StockTakeEntry.Properties.EXPECTED_QUANTITY, StockTakeEntry.Properties.ACTUAL_QUANTITY, StockTakeEntry.Properties.VARIANCE, StockTakeEntry.Properties.OUTER_QTY, StockTakeEntry.Properties.OUTER_QTY_AS_QTY, StockTakeEntry.Properties.UNIT_QTY, StockTakeEntry.Properties.UNIT_QTY_AS_QTY);
    }

    private StockTakeView makeNoneType() {
        return StockTakeView.NORMAL_VIEW;
    }
}

