/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.takings;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.reports.takings.CashdrawerTakingsReport;
import ordermate.database.searchers.reports.takings.TakingsReportSearcher;

public class CashDrawerTakingsReportCompiler {
    private TakingsReportSearcher searcher;
    private List<FinanceUnit> financeUnits;
    private List<CashDrawer> activeCashDrawers;
    private List<CashdrawerTakingsReport> cachedResultsCashDrawers;

    public CashDrawerTakingsReportCompiler(TakingsReportSearcher searcherInstance) {
        this.searcher = searcherInstance;
    }

    public List<CashdrawerTakingsReport> getRawResultsCashDrawers() {
        if (this.getSearcher() != null) {
            this.getSearcher().setCashDrawers(this.getActiveCashDrawers());
            this.cachedResultsCashDrawers = this.getSearcher().search();
        }
        return this.cachedResultsCashDrawers;
    }

    public void resetResults() {
        this.cachedResultsCashDrawers = null;
        this.activeCashDrawers = null;
    }

    public List<String> getColumnTitles(boolean includeTotalColumn) {
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("Unit Type ");
        columnNames.add("Unit Name ");
        List<CashDrawer> allCashDrawers = this.getActiveCashDrawers();
        for (CashDrawer cashDrawer : allCashDrawers) {
            columnNames.add(cashDrawer.getLabel() + " ");
        }
        if (includeTotalColumn) {
            columnNames.add("Total/Restaurant Wide ");
        }
        return columnNames;
    }

    public List<List<String>> getCashDrawerPerFinanceUnitFiguresReportData(boolean includeTitleTotals, boolean includeTotalColumn) {
        ArrayList<List<String>> reportData = new ArrayList<List<String>>();
        String lastFinanceTitleUnitType = null;
        for (FinanceUnit unit : this.getAllNeededFinanceUnits()) {
            if (includeTitleTotals && lastFinanceTitleUnitType != null && !lastFinanceTitleUnitType.equals(unit.getType())) {
                reportData.add(this.getTotalRowForUnitType(lastFinanceTitleUnitType));
            }
            ArrayList<String> row = new ArrayList<String>();
            row.add(unit.getType());
            String gap = includeTitleTotals ? "  " : "";
            row.add(gap + unit.getLabel());
            Price rowTotalForAllCashdrawers = Price.ZERO_DOLLAR;
            for (CashDrawer drawer : this.getActiveCashDrawers()) {
                CashdrawerTakingsReport total = this.getCashdrawerForUnitDefinition(drawer, unit);
                if (total != null) {
                    row.add(total.getPaid().toString());
                    if (!includeTotalColumn) continue;
                    rowTotalForAllCashdrawers = rowTotalForAllCashdrawers.add(total.getPaid());
                    continue;
                }
                row.add("");
            }
            if (includeTotalColumn) {
                row.add(rowTotalForAllCashdrawers.toString());
            }
            reportData.add(row);
            lastFinanceTitleUnitType = unit.getType();
        }
        if (includeTitleTotals) {
            reportData.add(this.getTotalRowForUnitType(lastFinanceTitleUnitType));
        }
        return reportData;
    }

    private CashdrawerTakingsReport getCashdrawerForUnitDefinition(CashDrawer drawer, FinanceUnit unit) {
        for (CashdrawerTakingsReport taking : this.getCachedResultsCashDrawers()) {
            if (!taking.getCashDrawer().equals(drawer) || !taking.getUnitType().equals(unit)) continue;
            return taking;
        }
        return null;
    }

    private Price getSubTotal(CashDrawer drawer, String financeUnitType) {
        Price subTotal = Price.ZERO_DOLLAR;
        for (CashdrawerTakingsReport taking : this.getCachedResultsCashDrawers()) {
            if (!taking.getUnitType().getType().toString().equals(financeUnitType) || !taking.getCashDrawer().equals(drawer)) continue;
            subTotal = subTotal.add(taking.getPaid());
        }
        return subTotal;
    }

    private List<String> getTotalRowForUnitType(String unitType) {
        ArrayList<String> totalRow = new ArrayList<String>();
        totalRow.add("Total " + unitType);
        for (CashDrawer drawer : this.getActiveCashDrawers()) {
            totalRow.add(this.getSubTotal(drawer, unitType).toString());
        }
        return totalRow;
    }

    private TakingsReportSearcher getSearcher() {
        return this.searcher;
    }

    private List<CashdrawerTakingsReport> getCachedResultsCashDrawers() {
        if (this.cachedResultsCashDrawers == null) {
            this.cachedResultsCashDrawers = this.getRawResultsCashDrawers();
        }
        return this.cachedResultsCashDrawers;
    }

    private List<FinanceUnit> getAllNeededFinanceUnits() {
        if (this.financeUnits == null) {
            ObjectQuery oQuery = Query.select(FinanceUnit.class).active(FinanceUnit.class).wherePropertyIn(FinanceUnit.Properties.TYPE, new Object[]{FinanceUnit.CASH_TYPE.toString(), FinanceUnit.CREDIT_TYPE.toString(), FinanceUnit.DEBIT_TYPE.toString(), FinanceUnit.WEB_TYPE.toString()}).orderBy(FinanceUnit.Properties.TYPE).orderBy(FinanceUnit.Properties.LABEL);
            this.financeUnits = PersistenceManager.getObjectList(FinanceUnit.class, oQuery.toString());
        }
        return this.financeUnits;
    }

    private List<CashDrawer> getActiveCashDrawers() {
        if (this.activeCashDrawers == null) {
            ObjectQuery oQuery = Query.select(CashDrawer.class).active(CashDrawer.class);
            this.activeCashDrawers = PersistenceManager.getObjectList(CashDrawer.class, oQuery.toString());
        }
        return this.activeCashDrawers;
    }
}

