/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.takings;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import org.hibernate.annotations.AccessType;

@Entity
@AccessType(value="property")
public class CashdrawerTakingsReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<FinanceUnit> unitType;
    private Reference<CashDrawer> cashDrawer;
    private Price paid;
    private Price tips;

    public CashdrawerTakingsReport() {
        this.unitType = this.createReference(CashdrawerTakingsReport.Properties.UNIT_TYPE);
        this.cashDrawer = this.createReference(CashdrawerTakingsReport.Properties.CASH_DRAWER);
        this.paid = Price.ZERO_DOLLAR;
        this.tips = Price.ZERO_DOLLAR;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_cashdrawer")
    public CashDrawer getCashDrawer() {
        return this.cashDrawer.get();
    }

    public void setCashDrawer(CashDrawer cashDrawer) {
        this.cashDrawer.set(cashDrawer);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_finance_unit")
    public FinanceUnit getUnitType() {
        return this.unitType.get();
    }

    public void setUnitType(FinanceUnit unitType) {
        this.unitType.set(unitType);
    }

    @Column(name="total")
    public Price getPaid() {
        return this.paid;
    }

    public void setPaid(Price paid) {
        this.paid = paid;
    }

    @Column(name="total_tips")
    public Price getTips() {
        return this.tips;
    }

    public void setTips(Price tips) {
        this.tips = tips;
    }

    @Transient
    public String getCashDrawerName() {
        return this.getCashDrawer().getLabel();
    }

    @Transient
    public String getUnitLabel() {
        return this.getUnitType().getLabel();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<FinanceUnit> UNIT_TYPE;
        public PropertiedObject.Property<CashDrawer> CASH_DRAWER;
        public PropertiedObject.Property<Price> PAID;
        public PropertiedObject.Property<Price> TIPS;
        public PersistentObject.DerivedProperty<String> UNIT_LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerTakingsReport.class), "unitLabel");
        public PersistentObject.DerivedProperty<String> CASH_DRAWER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CashdrawerTakingsReport.class), "cashDrawerName");
    }
}

