/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.takings;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;

public class DailyTakingsReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<TradingDay> tradingDay;
    private Reference<DayPart> dayPart;
    private Price systemTakings;
    private Price actualTakings;

    public DailyTakingsReport() {
        this.tradingDay = this.createReference(DailyTakingsReport.Properties.TRADING_DAY);
        this.dayPart = this.createReference(DailyTakingsReport.Properties.DAY_PART);
        this.actualTakings = Price.ZERO_NO_ROUND;
    }

    public DailyTakingsReport(TradingDay day, Price systemTakings, Price actualTakings) {
        this.tradingDay = this.createReference(DailyTakingsReport.Properties.TRADING_DAY);
        this.dayPart = this.createReference(DailyTakingsReport.Properties.DAY_PART);
        this.actualTakings = Price.ZERO_NO_ROUND;
        this.setTradingDay(day);
        this.setSystemTakings(systemTakings);
        this.setActualTakings(actualTakings);
    }

    public DailyTakingsReport(TradingDay day, Price systemTakings) {
        this(day, systemTakings, Price.ZERO_NO_ROUND);
    }

    public Date getDate() {
        if (this.getTradingDay() == null) {
            return null;
        }
        return this.getTradingDay().getDate();
    }

    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    public void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    public DayPart getDayPart() {
        return this.dayPart.get();
    }

    public void setDayPart(DayPart value) {
        this.dayPart.set(value);
    }

    public Price getActualTakings() {
        return this.actualTakings;
    }

    public void setActualTakings(Price value) {
        this.actualTakings = value;
    }

    public Price getSystemTakings() {
        return this.systemTakings;
    }

    public void setSystemTakings(Price value) {
        this.systemTakings = value;
    }

    public void addActual(Price moreTakings) {
        this.actualTakings = this.actualTakings.add(moreTakings);
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Price> SYSTEM_TAKINGS;
        public PropertiedObject.Property<Price> ACTUAL_TAKINGS;
        public PropertiedObject.Property<DayPart> DAY_PART;
        public PersistentObject.DerivedProperty<Date> DAY_DATE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DailyTakingsReport.class), "date");
    }
}

