/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.takings;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.takings.DailyTakingsReport;
import ordermate.database.searchers.reports.takings.TakingsReportSearcher;

public class DayToDayReportCompiler {
    private TakingsReportSearcher searcher;
    private List<DailyTakingsReport> cachedResults = new ArrayList<DailyTakingsReport>();

    public DayToDayReportCompiler(TakingsReportSearcher searcher) {
        this.searcher = searcher;
    }

    private TakingsReportSearcher getSearcher() {
        return this.searcher;
    }

    public Object[][] searchWithSQL(Date from, Date to) {
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery(this.getDayToDayTakingsQuery(from, to).toString(), null);
        return result;
    }

    public ObjectQuery getDayToDayTakingsQuery(Date from, Date to) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.sum(FinanceTransaction.Properties.PAID, "paid").select(TradingDay.Properties.ID).linkUsing(FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.Properties.ID).linkUsing(FinanceTransaction.Properties.TRADING_DAY, TradingDay.Properties.ID).not().equals(FinanceTransaction.Properties.SYSTEM_STATE, "DELETED").isNull(FinanceTransaction.Properties.MOVED_TRANSACTION).wherePropertyBetween(TradingDay.Properties.DATE, from, to, SQLDateType.DATE).wherePropertyIn(FinanceUnit.Properties.TYPE, new Object[]{FinanceUnit.CASH_TYPE.toString(), FinanceUnit.CREDIT_TYPE.toString(), FinanceUnit.DEBIT_TYPE.toString(), FinanceUnit.WEB_TYPE.toString()}).groupBy(TradingDay.Properties.ID);
        return oQuery;
    }

    public List<DailyTakingsReport> getDayToDayForPeriod() {
        this.cachedResults.clear();
        Object[][] transactions = this.searchWithSQL((Date)this.getSearcher().getDateRangeFilter().getStart(), (Date)this.getSearcher().getDateRangeFilter().getEnd());
        for (int i = 0; i < transactions.length; ++i) {
            DailyTakingsReport newEntry;
            TradingDay currentDay = null;
            Price takings = null;
            if (transactions[i][1] instanceof Long) {
                currentDay = PersistenceManager.getByID((Long)transactions[i][1], TradingDay.class);
            }
            if (transactions[i][0] instanceof Double) {
                takings = new Price((Double)transactions[i][0], 0.01);
            }
            if (currentDay == null || takings == null || this.cachedResults.contains(newEntry = new DailyTakingsReport(currentDay, takings))) continue;
            this.cachedResults.add(newEntry);
        }
        return this.cachedResults;
    }
}

