/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.takings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.searchers.reports.adjustments.AdjustmentsReportSearcher;
import ordermate.database.searchers.reports.takings.TakingsReportSearcher;

public class DiscountsReportCompiler {
    private TakingsReportSearcher searcher;
    private AdjustmentsReportSearcher discountSearcher;
    private List<AdjustmentsReport> cachedResults = new ArrayList<AdjustmentsReport>();

    public DiscountsReportCompiler(TakingsReportSearcher searcher) {
        this.searcher = searcher;
        this.discountSearcher = this.getAdjustmentSearcher();
    }

    private AdjustmentsReportSearcher getAdjustmentSearcher() {
        if (this.discountSearcher == null) {
            this.discountSearcher = new AdjustmentsReportSearcher(PriceAdjustmentDirection.DISCOUNT);
            this.discountSearcher.setDateRange((Date)this.searcher.getDateRangeFilter().getStart(), (Date)this.searcher.getDateRangeFilter().getEnd());
        }
        return this.discountSearcher;
    }

    public List<String> getReportDisplayableColumnNames() {
        List<String> newList = Arrays.asList("Discount", "Description", "Cost", "Number");
        return newList;
    }

    public void setDateRange(Date from, Date to) {
        this.getAdjustmentSearcher().setDateRange(from, to);
    }

    public List<AdjustmentsReport> getResults() {
        List searchResults = this.getAdjustmentSearcher().search();
        this.cachedResults.clear();
        for (AdjustmentsReport discount : searchResults) {
            AdjustmentsReport storedElement = this.getCachedResultsDiscountElement(discount);
            if (storedElement == null) {
                this.cachedResults.add(discount);
                continue;
            }
            storedElement.setSavedTotal(storedElement.getSavedTotal().add(discount.getSavedTotal()));
            storedElement.setNumber(storedElement.getNumber() + 1L);
        }
        return this.cachedResults;
    }

    private AdjustmentsReport getCachedResultsDiscountElement(AdjustmentsReport element) {
        for (AdjustmentsReport discount : this.cachedResults) {
            if (!discount.getAmount().equals(element.getAmount()) || !discount.getName().equals(element.getName())) continue;
            return discount;
        }
        return null;
    }
}

