/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.takings;

import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ChartBuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.builders.DJBuilderException;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.builder.DJBarChartBuilder;
import ar.com.fdvs.dj.domain.chart.plot.DJAxisFormat;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.OrderMate;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.takings.CashDrawerTakingsReportCompiler;
import ordermate.database.reports.takings.CashdrawerTakingsGenericBiListTableModel;
import ordermate.database.reports.takings.DailyTakingsReport;
import ordermate.database.reports.takings.DayToDayReportCompiler;
import ordermate.database.reports.takings.DiscountsReportCompiler;
import ordermate.database.searchers.reports.takings.TakingsReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class TakingsSummaryReportProvider
extends AbstractReportProvider {
    private static final String CASHDRAWER_TAKINGS = "CASHDRAWER_TAKINGS";
    private static final String DISCOUNTS_SUMMARY = "DISCOUNTS_SUMMARY";
    private static final String DAY_DAY_TAKINGS = "DAY_DAY_TAKINGS";
    private static final String DAY_DAY_CHARTS = "DAY_DAY_CHARTS";
    private TakingsReportSearcher searcher;
    private CashDrawerTakingsReportCompiler cashDrawerCompiler;
    private CashdrawerTakingsGenericBiListTableModel cashdrawerTableModel;
    private DiscountsReportCompiler discountCompiler;
    private DayToDayReportCompiler dayToDayCompiler;
    private List<PropertyColumn> totalColumnProperties = new ArrayList<PropertyColumn>();

    public TakingsSummaryReportProvider() {
        this(new TakingsReportSearcher());
    }

    public TakingsSummaryReportProvider(TakingsReportSearcher searcher) {
        this.searcher = searcher;
        this.cashDrawerCompiler = new CashDrawerTakingsReportCompiler(searcher);
        this.discountCompiler = new DiscountsReportCompiler(searcher);
        this.dayToDayCompiler = new DayToDayReportCompiler(searcher);
        this.totalColumnProperties.clear();
    }

    public TakingsReportSearcher getSearcher() {
        return this.searcher;
    }

    public CashDrawerTakingsReportCompiler getCashDrawerCompiler() {
        return this.cashDrawerCompiler;
    }

    public DiscountsReportCompiler getDiscountCompiler() {
        return this.discountCompiler;
    }

    public DayToDayReportCompiler getDayToDayCompiler() {
        return this.dayToDayCompiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanArrayDataSource(new Object[]{"DummyData"});
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle(), ReportBuilder.TemplateFormat.A4Landscape);
        builder.setTitle("Takings Summary");
        builder.setSubtitle(this.generateSubtitle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.getReportBuilder().setPageSizeAndOrientation(Page.Page_A4_Landscape());
        this.addCashDrawerTakingsSubReport(builder);
        this.addDiscountSummarySubReport(builder);
        this.addDayToDayTakingsSubReport(builder);
        return builder;
    }

    private String generateSubtitle() {
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getTradingDayDateRangeAdapter(), null);
        this.getHelper().appendSearchFilter(SB, "Cashdrawers", this.searcher.getCashdrawerFilter());
        this.getHelper().appendSearchFilter(SB, "Shift", this.searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.searcher.getSalesLocationFilter());
        return SB.toString();
    }

    private void addCashDrawerTakingsSubReport(ReportBuilder superBuilder) throws BuilderException {
        ReportBuilder cashDrawerBuilder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        cashDrawerBuilder.setTitle("Cashdrawer Takings Summaries");
        cashDrawerBuilder.setSubtitle(this.getDateSubTitleString());
        this.getCashDrawerCompiler().resetResults();
        super.getParameters().put(CASHDRAWER_TAKINGS, new JRTableModelDataSource((TableModel)this.getCashDrawerTakingsModel(true)));
        Style totalStyle = this.getNewTotalLineStyle();
        int columnCount = 0;
        for (String name : this.getCashDrawerCompiler().getColumnTitles(true)) {
            ColumnProperty prop;
            SimpleColumn column = new SimpleColumn();
            if (columnCount < 2) {
                prop = new ColumnProperty(name, String.class);
            } else {
                prop = new ColumnProperty(name, Number.class);
                column.setPattern(Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
            }
            column.setColumnProperty(prop);
            column.setName(name);
            column.setTitle(name.substring(0, name.length() - 1));
            cashDrawerBuilder.getReportBuilder().addColumn((AbstractColumn)column);
            if (columnCount == 0) {
                DJGroup group = new DJGroup();
                group.setColumnToGroupBy((PropertyColumn)column);
                group.setReprintHeaderOnEachPage(Boolean.TRUE);
                group.setAllowHeaederSplit(false);
                group.setAllowFooterSplit(false);
                cashDrawerBuilder.getReportBuilder().addGroup(group);
            }
            if (columnCount >= 2) {
                Style headerRightAlign = JasperReportHelper.rightAlignStyle(cashDrawerBuilder.getStyles().getColumnHeaderStyle());
                column.setHeaderStyle(headerRightAlign);
                Style rightAlign = JasperReportHelper.rightAlignStyle(cashDrawerBuilder.getStyles().getColumnDetailStyle());
                column.setStyle(rightAlign);
                cashDrawerBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)column, new PriceTotalExpression(columnCount), totalStyle);
            } else {
                Style rowTitleStyle = JasperReportHelper.leftAlignStyle(JasperReportHelper.enableBoldFont(cashDrawerBuilder.getStyles().getColumnDetailStyle(), false));
                column.setStyle(rowTitleStyle);
            }
            ++columnCount;
        }
        cashDrawerBuilder.getReportBuilder().setGrandTotalLegend("TOTALS: ");
        cashDrawerBuilder.getReportBuilder().setGrandTotalLegendStyle(this.getTotalTagStyle());
        cashDrawerBuilder.getReportBuilder().setUseFullPageWidth(true);
        cashDrawerBuilder.getReportBuilder().setAllowDetailSplit(true);
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(cashDrawerBuilder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), CASHDRAWER_TAKINGS, 0, 10);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate cashdrawer takings subreport :", (Throwable)ex);
        }
    }

    private CashdrawerTakingsGenericBiListTableModel getCashDrawerTakingsModel(boolean refreshed) {
        if (this.cashdrawerTableModel == null || refreshed) {
            this.cashdrawerTableModel = new CashdrawerTakingsGenericBiListTableModel(this.getCashDrawerCompiler().getColumnTitles(true), this.getCashDrawerCompiler().getCashDrawerPerFinanceUnitFiguresReportData(false, true));
        }
        return this.cashdrawerTableModel;
    }

    private void addDiscountSummarySubReport(ReportBuilder superBuilder) throws ColumnBuilderException {
        ReportBuilder discountBuilder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        discountBuilder.setTitle("Restaurant Discount Summary");
        discountBuilder.setSubtitle(this.getDateSubTitleString());
        if (this.searcher != null) {
            this.getDiscountCompiler().setDateRange((Date)this.searcher.getDateRangeFilter().getStart(), (Date)this.searcher.getDateRangeFilter().getEnd());
        }
        super.getParameters().put(DISCOUNTS_SUMMARY, new JRBeanCollectionDataSource(this.getDiscountCompiler().getResults()));
        Object[] colNames = this.getDiscountCompiler().getReportDisplayableColumnNames().toArray();
        discountBuilder.addReportColumn(AdjustmentsReport.Properties.DISCOUNT_AMOUNT, String.valueOf(colNames[0]), null);
        discountBuilder.addReportColumn(AdjustmentsReport.Properties.NAME, String.valueOf(colNames[1]), null);
        discountBuilder.addReportColumn(AdjustmentsReport.Properties.COST, String.valueOf(colNames[2]), Internationalization.getLiteralFor("PRICE_PATTERN"));
        discountBuilder.addReportColumn(AdjustmentsReport.Properties.NUMBER, String.valueOf(colNames[3]), null);
        Style costHeaderRightAlign = JasperReportHelper.rightAlignStyle(discountBuilder.getStyles().getColumnHeaderStyle());
        discountBuilder.getPropertyColumn(AdjustmentsReport.Properties.COST).setHeaderStyle(costHeaderRightAlign);
        discountBuilder.getPropertyColumn(AdjustmentsReport.Properties.NUMBER).setHeaderStyle(costHeaderRightAlign);
        Style costRightAlign = JasperReportHelper.rightAlignStyle(discountBuilder.getStyles().getColumnDetailStyle());
        discountBuilder.getPropertyColumn(AdjustmentsReport.Properties.COST).setStyle(JasperReportHelper.rightAlignStyle(costRightAlign));
        discountBuilder.getPropertyColumn(AdjustmentsReport.Properties.NUMBER).setStyle(costRightAlign);
        discountBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)discountBuilder.getPropertyColumn(AdjustmentsReport.Properties.COST), DJCalculation.SUM, this.getNewTotalLineStyle());
        discountBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)discountBuilder.getPropertyColumn(AdjustmentsReport.Properties.NUMBER), DJCalculation.SUM, this.getNewTotalLineStyle());
        discountBuilder.getReportBuilder().setGrandTotalLegendStyle(this.getTotalTagStyle());
        discountBuilder.getReportBuilder().setGrandTotalLegend("TOTALS: ");
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(discountBuilder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), DISCOUNTS_SUMMARY, 0, 10, true);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate discounts summary subreport :", (Throwable)ex);
        }
    }

    private void addDayToDayTakingsSubReport(ReportBuilder superBuilder) throws ColumnBuilderException, ChartBuilderException {
        ReportBuilder daydayBuilder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        daydayBuilder.setTitle("Day-Day Takings Summary");
        daydayBuilder.setSubtitle(this.getDateSubTitleString());
        super.getParameters().put(DAY_DAY_TAKINGS, new JRBeanCollectionDataSource(this.getDayToDayCompiler().getDayToDayForPeriod()));
        daydayBuilder.addReportColumn(DailyTakingsReport.Properties.SYSTEM_TAKINGS, "Total", Internationalization.getLiteralFor("PRICE_PATTERN"));
        Style styleRightAlignDetail = JasperReportHelper.rightAlignStyle(daydayBuilder.getStyles().getColumnDetailStyle());
        Style styleRightAlignHeader = JasperReportHelper.rightAlignStyle(daydayBuilder.getStyles().getColumnHeaderStyle());
        daydayBuilder.getPropertyColumn(DailyTakingsReport.Properties.SYSTEM_TAKINGS).setStyle(styleRightAlignDetail);
        daydayBuilder.getPropertyColumn(DailyTakingsReport.Properties.SYSTEM_TAKINGS).setHeaderStyle(styleRightAlignHeader);
        daydayBuilder.getReportBuilder().addGlobalFooterVariable((AbstractColumn)daydayBuilder.getPropertyColumn(DailyTakingsReport.Properties.SYSTEM_TAKINGS), DJCalculation.SUM, this.getNewTotalLineStyle());
        daydayBuilder.getReportBuilder().setGrandTotalLegend("TOTALS: ");
        daydayBuilder.getReportBuilder().setGrandTotalLegendStyle(this.getTotalTagStyle());
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(daydayBuilder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), DAY_DAY_TAKINGS, 0, 10, true);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate day-day takings summary subreport :", (Throwable)ex);
        }
    }

    private void addDayToDayChartSubReport(ReportBuilder superBuilder) throws ChartBuilderException {
        super.getParameters().put(DAY_DAY_CHARTS, new JRBeanCollectionDataSource(this.getDayToDayCompiler().getDayToDayForPeriod()));
        ReportBuilder daydayChartBuilder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        daydayChartBuilder.addInvisibleField(DailyTakingsReport.Properties.DAY_PART);
        daydayChartBuilder.addInvisibleField(DailyTakingsReport.Properties.SYSTEM_TAKINGS);
        DJBarChartBuilder chartBuilder = new DJBarChartBuilder();
        chartBuilder.setX(this.getDateRangeForXAxis()).setY(this.getMaximumSalesAmountForYAxis()).setWidth(400).setHeight(200).setCentered(true).setBackColor(Color.LIGHT_GRAY).setShowLegend(true).setPosition((byte)1).setTitle("Takings Summary").setTitleColor(Color.DARK_GRAY).setLegendColor(Color.DARK_GRAY).setLegendBackgroundColor(Color.WHITE).setLegendPosition((byte)2).setTitlePosition((byte)1).setLineStyle((byte)2).setLineWidth(1.0f).setLineColor(Color.DARK_GRAY).setPadding(5).setCategory(daydayChartBuilder.getPropertyColumn(DailyTakingsReport.Properties.SYSTEM_TAKINGS)).setValueAxisFormat(new DJAxisFormat("Trading Day / Sales (" + Internationalization.getLiteralFor("DOLLAR_SIGN") + ")")).addSerie((AbstractColumn)daydayChartBuilder.getPropertyColumn(DailyTakingsReport.Properties.SYSTEM_TAKINGS), "Takings").addSerie((AbstractColumn)daydayChartBuilder.getPropertyColumn(DailyTakingsReport.Properties.DAY_PART), "Day Date");
        DJChart build = chartBuilder.build();
        build.getPlot().setLabelRotation(Double.valueOf(90.0));
        daydayChartBuilder.getReportBuilder().addChart(build);
        try {
            superBuilder.getReportBuilder().addConcatenatedReport(daydayChartBuilder.buildJasperReport(), (LayoutManager)new ClassicLayoutManager(), DAY_DAY_CHARTS, 0, 10, true);
        }
        catch (DJBuilderException ex) {
            OrderMate.LOG.error("Cannot instantiate day-day takings chart subreport :", (Throwable)ex);
        }
    }

    private int getDateRangeForXAxis() {
        return 3;
    }

    private int getMaximumSalesAmountForYAxis() {
        return 70;
    }

    private Style getNewTotalLineStyle() {
        Style totalLineStyle = new OrderMateOmorphosReportStyle().getColumnDetailStyle();
        totalLineStyle.getFont().setBold(true);
        totalLineStyle.setTextColor(Color.BLACK);
        totalLineStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        return totalLineStyle;
    }

    private Style getTotalTagStyle() {
        Style total = this.getNewTotalLineStyle();
        total.setHorizontalAlign(HorizontalAlign.LEFT);
        return total;
    }

    private String getDateSubTitleString() {
        return "from " + DateTimeUtils.getDateTimeFormat().format((Date)this.getSearcher().getTradingDayDateRangeAdapter().getStart()) + " to " + DateTimeUtils.getDateTimeFormat().format((Date)this.getSearcher().getTradingDayDateRangeAdapter().getEnd());
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }

    private class PriceTotalExpression
    implements CustomExpression {
        int columnIndex;

        public PriceTotalExpression(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Object evaluate(Map arg0, Map arg1, Map arg2) {
            return TakingsSummaryReportProvider.this.getCashDrawerTakingsModel(false).getTotalForColumn(this.columnIndex);
        }

        public String getClassName() {
            return Number.class.getName();
        }
    }
}

