/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.tax;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;

public class TaxCodeReportItem
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Price amount = Price.ZERO_DOLLAR;
    private Reference<TaxCode> taxCode;
    private Reference<TradingDay> tradingDay;
    private Reference<DayPart> dayPart;

    public TaxCodeReportItem() {
        this.taxCode = this.createReference(TaxCodeReportItem.Properties.TAX_CODE);
        this.tradingDay = this.createReference(TaxCodeReportItem.Properties.TRADING_DAY);
        this.dayPart = this.createReference(TaxCodeReportItem.Properties.DAY_PART);
    }

    public TaxCodeReportItem(TaxCode code) {
        this();
        this.taxCode.set(code);
    }

    public TaxCode getTaxCode() {
        return this.taxCode.get();
    }

    protected void setTaxCode(TaxCode value) {
        this.taxCode.set(value);
    }

    public Price getAmount() {
        return this.amount;
    }

    public void setAmount(Price newAmount) {
        this.amount = newAmount;
    }

    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    public DayPart getDayPart() {
        return this.dayPart.get();
    }

    protected void setDayPart(DayPart value) {
        this.dayPart.set(value);
    }

    public void add(TaxCodeReportItem otherItem) {
        this.amount = this.amount.add(otherItem.amount);
    }

    public String getDescription() {
        return this.getTaxCode().getDescription();
    }

    public Double getTaxRate() {
        return this.getTaxCode().getRate();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<TaxCode> TAX_CODE;
        public PropertiedObject.Property<Price> AMOUNT;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<DayPart> DAY_PART;
        public PersistentObject.DerivedProperty TAX_RATE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TaxCodeReportItem.class), "taxRate");
        public PersistentObject.DerivedProperty DESCRIPTION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TaxCodeReportItem.class), "description");
    }
}

