/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.tax;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.reports.tax.TaxCodeReportItem;
import ordermate.database.reports.tax.TaxCodeReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class TaxCodeReportProvider
extends AbstractReportProvider {
    private TaxCodeReportSearcher searcher;

    public TaxCodeReportProvider(TaxCodeReportSearcher theSearcher) {
        this.searcher = theSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new SearcherDataSourceProvider<TaxCodeReportSearcher>(this.searcher).getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.setTitle("Tax Code Report");
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getTradingDayDateRangeFilter(), null);
        this.getHelper().appendSearchFilter(SB, "Shift", this.searcher.getShiftFilter());
        this.getHelper().appendRangeSearchFilter(SB, "Shifts", this.searcher.getShiftRangeFilter(), null);
        builder.setSubtitle(SB.toString());
        builder.addReportColumn(TaxCodeReportItem.Properties.TAX_CODE, null);
        builder.addReportColumn(TaxCodeReportItem.Properties.DESCRIPTION, null);
        builder.addReportColumn(TaxCodeReportItem.Properties.TAX_RATE, "0.#%");
        builder.addReportColumn(TaxCodeReportItem.Properties.AMOUNT, Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

