/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.tax;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeQuerySearchFilter;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.ISingleValueSearchFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.misc.DayPartHelper;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.tax.TaxCodeReportItem;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesComponentTax;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.searchers.reports.TradingDayFilteredReportSearcher;

public class TaxCodeReportSearcher
extends PropertySearcher<TaxCodeReportItem>
implements TradingDayFilteredReportSearcher<TaxCodeReportItem> {
    private IRangedQuerySearchFilter<Date> tradingDayDateFilter;
    private IRangedQuerySearchFilter<Date> tradingDayDateFilterSIQ;
    private ISingleValueSearchFilter<TradingDay> tradingDayFilter;
    private ISingleValueSearchFilter<TradingDay> tradingDayFilterSIQ;
    private IRangedQuerySearchFilter<Long> tradingDayRangeFilter;
    private IRangedQuerySearchFilter<Long> tradingDayRangeFilterSIQ;
    private TradingDayDateRangeFilterAdapter tradingDayDateRangeAdapter;
    private IRangedQuerySearchFilter<Long> shiftRangeFilter;
    private ISingleValueSearchFilter<Shift> shiftFilter;
    private MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private List<PropertiedObject.Property> groupBys;
    private boolean ensureAllCodes;
    private boolean tradingDayBySIQ;
    private boolean groupByDayPart;
    private TaxSearchType searchType;

    public TaxCodeReportSearcher() {
        super(TaxCodeReportItem.class);
        this.tradingDayDateFilter = new RangeJoinSearchFilter<Date>(new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP), Account.Properties.TRADING_DAY);
        this.tradingDayDateFilterSIQ = new RangeJoinSearchFilter<Date>(new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.TIMESTAMP), SalesItemQuantity.Properties.TRADING_DAY);
        this.tradingDayFilter = new ObjectSearchFilter<TradingDay>(Account.Properties.TRADING_DAY);
        this.tradingDayFilterSIQ = new ObjectSearchFilter<TradingDay>(SalesItemQuantity.Properties.TRADING_DAY);
        this.tradingDayRangeFilter = new RangeQuerySearchFilter<Long>(Account.Properties.TRADING_DAY);
        this.tradingDayRangeFilterSIQ = new RangeQuerySearchFilter<Long>(SalesItemQuantity.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.tradingDayDateFilter);
        this.shiftRangeFilter = new RangeQuerySearchFilter<Long>(Account.Properties.SHIFT);
        this.shiftFilter = new ObjectSearchFilter<Shift>(Account.Properties.SHIFT);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(SalesItemQuantity.Properties.SALES_LOCATION);
        this.ensureAllCodes = true;
        this.tradingDayBySIQ = false;
        this.groupByDayPart = false;
        this.searchType = TaxSearchType.TaxPayable;
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.tradingDayFilter);
        this.addSearchFilter(this.tradingDayRangeFilter);
        this.addSearchFilter(this.shiftRangeFilter);
        this.addSearchFilter(this.shiftFilter);
    }

    public void setTradingDayBySIQ(boolean value, boolean groupByDayPart) {
        this.tradingDayBySIQ = value;
        if (this.tradingDayBySIQ) {
            this.removeSearchFilter(this.tradingDayFilter);
            this.removeSearchFilter(this.tradingDayRangeFilter);
            this.tradingDayDateRangeAdapter.setUnderlyingFilter(this.tradingDayDateFilterSIQ);
            this.addSearchFilter(this.tradingDayFilterSIQ);
            this.addSearchFilter(this.tradingDayRangeFilterSIQ);
            this.addSearchFilter(this.salesLocationFilter);
        } else {
            this.removeSearchFilter(this.tradingDayFilterSIQ);
            this.removeSearchFilter(this.tradingDayRangeFilterSIQ);
            this.tradingDayDateRangeAdapter.setUnderlyingFilter(this.tradingDayDateFilter);
            this.addSearchFilter(this.tradingDayFilter);
            this.addSearchFilter(this.tradingDayRangeFilter);
            this.removeSearchFilter(this.salesLocationFilter);
        }
        this.groupByDayPart = groupByDayPart;
    }

    public void setSearchType(TaxSearchType type) {
        this.searchType = type;
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = null;
        if (TaxSearchType.TaxPayable.equals((Object)this.searchType)) {
            query = Query.select(TaxCode.Properties.ID, "tax_code_id").selectFunc("IFNULL(SUM(sales_component_tax.value * sales_item_quantity.quantity),0) AS amount");
            if (this.tradingDayBySIQ) {
                query.select(SalesItemQuantity.Properties.TRADING_DAY);
                query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("sales_item_quantity.creation_time"));
                query.groupBy("fk_config_day_part");
            } else {
                query.linkUsing(Account.Properties.ID, SalesItem.Properties.ACCOUNT);
                query.select(Account.Properties.TRADING_DAY);
                query.selectFunc("null as fk_config_day_part");
            }
            query.linkUsing(SalesComponentTax.Properties.TAX_CODE, TaxCode.Properties.ID).linkUsing(SalesComponent.Properties.ID, SalesComponentTax.Properties.SALES_COMPONENT).linkUsing(SalesItem.Properties.ID, SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).groupBy(TaxCode.Properties.ID).orderBy(TaxCode.Properties.ID);
        } else if (TaxSearchType.TotalTaxSales.equals((Object)this.searchType)) {
            Long taxId = TaxCode.getGstCode().getID();
            Long freeId = TaxCode.getFreeCode().getID();
            query = Query.selectFunc("IF(sales_item_quantity.quantity * sales_component.unit_tax = 0.0, " + freeId + ", " + taxId + ") AS tax_code_id").selectFunc("IFNULL(SUM(sales_item_quantity.quantity * sales_component.unit_price),0) AS amount");
            if (this.tradingDayBySIQ) {
                query.select(SalesItemQuantity.Properties.TRADING_DAY);
                if (this.groupByDayPart) {
                    query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("sales_item_quantity.creation_time"));
                    query.groupBy("fk_config_day_part");
                }
            } else {
                query.select(Account.Properties.TRADING_DAY).linkUsing(Account.Properties.ID, SalesItem.Properties.ACCOUNT);
                if (this.groupByDayPart) {
                    query.selectFunc(DayPartHelper.INSTANCE.getSelectDayPartAsIDQuery("sales_account.creation_time"));
                    query.groupBy("fk_config_day_part");
                }
            }
            if (!this.groupByDayPart) {
                query.selectFunc("null as fk_config_day_part");
            }
            query.linkUsing(SalesItem.Properties.ID, SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).groupBy("tax_code_id").orderBy("tax_code_id", false);
        } else {
            throw new IllegalStateException("Unknown tax report search type:" + (Object)((Object)this.searchType));
        }
        if (this.groupBys != null) {
            for (PropertiedObject.Property nextGroup : this.groupBys) {
                query.groupBy(nextGroup);
            }
        }
        return query;
    }

    @Override
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeFilter() {
        return this.tradingDayDateFilter;
    }

    @Override
    @FilterConfig(name="Date Range", dataType=Date.class, dateType=SQLDateType.DATE, nullAllowed=false, plural=FilterConfig.Plural.Ranged, priority=true, sequence=1)
    public IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        return this.tradingDayDateRangeAdapter;
    }

    @Override
    public ISingleValueSearchFilter<TradingDay> getTradingDayFilter() {
        return this.tradingDayFilter;
    }

    public IRangedQuerySearchFilter<Long> getTradingDayRangeFilter() {
        return this.tradingDayRangeFilter;
    }

    public IRangedQuerySearchFilter<Long> getShiftRangeFilter() {
        return this.shiftRangeFilter;
    }

    public ISingleValueSearchFilter<Shift> getShiftFilter() {
        return this.shiftFilter;
    }

    @Override
    public String getDisplayableDate() {
        return TradingDayFilteredReportSearcher.DisplayHelper.getDisplayableDate(this);
    }

    public void ensureHasAllCodes(boolean value) {
        this.ensureAllCodes = value;
    }

    @Override
    public List<TaxCodeReportItem> search() {
        List<TaxCodeReportItem> superList = super.search();
        if (this.ensureAllCodes) {
            this.ensureEntriesForEachCode(superList);
        }
        return superList;
    }

    public void addGroupBy(PropertiedObject.Property group) {
        if (group == null) {
            return;
        }
        if (this.groupBys == null) {
            this.groupBys = new ArrayList<PropertiedObject.Property>();
        }
        if (!this.groupBys.contains(group)) {
            this.groupBys.add(group);
        }
    }

    private void ensureEntriesForEachCode(List<TaxCodeReportItem> reportList) {
        LinkedHashSet<TaxCode> toAdd = new LinkedHashSet<TaxCode>(TaxCode.getInventoryTaxCodes());
        for (TaxCodeReportItem item : reportList) {
            toAdd.remove(item.getTaxCode());
        }
        if (!toAdd.isEmpty()) {
            for (TaxCode nextCode : toAdd) {
                reportList.add(new TaxCodeReportItem(nextCode));
            }
        }
    }

    public MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        return this.salesLocationFilter;
    }

    public static enum TaxSearchType {
        TaxPayable,
        TotalTaxSales;

    }
}

