/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.timesheet;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ordermate.database.departments.Department;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.finance.timesheet.TimesheetSummaryReport;
import ordermate.database.searchers.reports.timesheet.FinanceTimesheetSearcher;
import org.apache.commons.collections.map.MultiKeyMap;

public class TimesheetSummaryReportByUserCompiler {
    private FinanceTimesheetSearcher timesheetSearcher;
    private MultiKeyMap cachedResults;

    public TimesheetSummaryReportByUserCompiler(FinanceTimesheetSearcher timesheetSearchState) {
        this.timesheetSearcher = timesheetSearchState;
        this.cachedResults = new MultiKeyMap();
    }

    public List<TimesheetSummaryReport> getResults() {
        this.cachedResults.clear();
        List<FinanceTimesheet> searchResults = this.timesheetSearcher.search();
        for (FinanceTimesheet timesheet : searchResults) {
            String dept;
            String user = timesheet.getUser().getName();
            TimesheetSummaryReport summary = (TimesheetSummaryReport)this.cachedResults.get((Object)user, (Object)(dept = timesheet.getDepartment() == null ? "" : timesheet.getDepartment().getName()));
            if (summary == null) {
                summary = new TimesheetSummaryReport();
                summary.setUser(timesheet.getUser());
                summary.setDepartment(timesheet.getDepartment());
                this.cachedResults.put((Object)user, (Object)dept, (Object)summary);
            }
            summary.setTotalSeconds(summary.getTotalSeconds().add(BigDecimal.valueOf(timesheet.getTotalSeconds())));
            summary.setTotalPay(summary.getTotalPay().add(BigDecimal.valueOf(timesheet.getTotalPay().doubleValue())));
        }
        ArrayList<TimesheetSummaryReport> toReturn = new ArrayList<TimesheetSummaryReport>();
        toReturn.addAll(this.cachedResults.values());
        Collections.sort(toReturn, new Comparator<TimesheetSummaryReport>(){

            @Override
            public int compare(TimesheetSummaryReport o1, TimesheetSummaryReport o2) {
                int compare = o1.getUser().getName().compareTo(o2.getUser().getName());
                if (compare == 0) {
                    String payroll1 = o1.getPayrollId() == null ? "" : o1.getPayrollId();
                    String payroll2 = o2.getPayrollId() == null ? "" : o2.getPayrollId();
                    compare = payroll1.compareTo(payroll2);
                }
                if (compare == 0) {
                    Department dep1 = o1.getDepartment();
                    Department dep2 = o2.getDepartment();
                    if (dep1 == null) {
                        if (dep2 != null) {
                            compare = -1;
                        }
                    } else {
                        compare = dep2 == null ? 1 : dep1.getName().compareTo(dep2.getName());
                    }
                }
                return compare;
            }
        });
        return toReturn;
    }

    public FinanceTimesheetSearcher getSearcher() {
        return this.timesheetSearcher;
    }
}

