/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.timesheet;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.GroupLayout;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Arrays;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.finance.timesheet.TimesheetSummaryReport;
import ordermate.database.reports.timesheet.TimesheetSummaryReportByUserCompiler;
import ordermate.database.searchers.reports.timesheet.FinanceTimesheetSearcher;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class TimesheetSummaryReportByUserProvider
extends AbstractReportProvider {
    private TimesheetSummaryReportByUserCompiler compiler;
    private FinanceTimesheetSearcher searcher;

    public TimesheetSummaryReportByUserProvider(FinanceTimesheetSearcher yourSearcher) {
        this.searcher = yourSearcher;
        this.compiler = new TimesheetSummaryReportByUserCompiler(this.searcher);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRBeanCollectionDataSource(this.compiler.getResults());
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Timesheet Summary by User");
        builder.setSubtitle(this.getDateRangeForTitle());
        builder.addReportColumns(Arrays.asList(TimesheetSummaryReport.Properties.USER, TimesheetSummaryReport.Properties.PAYROLLID, TimesheetSummaryReport.Properties.DEPARTMENT, TimesheetSummaryReport.Properties.TOTAL_HOURS, TimesheetSummaryReport.Properties.TOTAL_PAY), "Name", "Payroll", "Department", "Hours", "Pay");
        ReportBuilder.PropertyCalculation sumHrs = new ReportBuilder.PropertyCalculation(TimesheetSummaryReport.Properties.TOTAL_HOURS, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumPay = new ReportBuilder.PropertyCalculation(TimesheetSummaryReport.Properties.TOTAL_PAY, DJCalculation.SUM);
        DJGroup group = builder.addGroupBy(TimesheetSummaryReport.Properties.USER, Arrays.asList(sumHrs, sumPay));
        DJGroupLabel footerLabel = new DJGroupLabel("Total: ", builder.getStyles().getFooterVariableStyle(), LabelPosition.LEFT);
        group.setLayout(GroupLayout.DEFAULT_WITH_HEADER);
        group.setFooterLabel(footerLabel);
        builder.setUseGrandTotal(true);
        builder.getReportBuilder().setGrandTotalLegend("Grand Total");
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_HOURS), Double.class, DJCalculation.SUM);
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_PAY), Double.class, DJCalculation.SUM);
        Style groupedColumnStyle = builder.getStyles().getGroupedDetailStyle();
        PropertyColumn groupCol = builder.getPropertyColumn(TimesheetSummaryReport.Properties.USER);
        groupCol.setHeaderStyle(groupedColumnStyle);
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setAllowHeaederSplit(false);
        group.setAllowFooterSplit(false);
        group.setHeaderHeight(Integer.valueOf(15));
        builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_PAY).setPattern("$0.00");
        builder.getReportBuilder().setAllowDetailSplit(true);
        return builder;
    }

    private String getDateRangeForTitle() {
        return "From " + DateTimeUtils.formatDateForDisplay((Date)this.searcher.getTradingDayDateRangeAdapter().getStart()) + " to " + DateTimeUtils.formatDateForDisplay((Date)this.searcher.getTradingDayDateRangeAdapter().getEnd());
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

