/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.timesheet;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJGroupLabel;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.constants.LabelPosition;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.glazedlists.SequentialComparator;
import au.com.ordermate.persistence.PropertiedObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.searchers.reports.timesheet.FinanceTimesheetSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.printing.HeaderSubReport;

public class TimesheetsDetailReportProvider
extends AbstractReportProvider {
    private Map<PropertiedObject.Property, String> columns = new LinkedHashMap<PropertiedObject.Property, String>();
    private List<FinanceTimesheet> currentReportItems;
    private DynamicReport report;
    protected Grouping grouping = Grouping.User;
    private Comparator<FinanceTimesheet> dateFirstComparator;
    private HashMap<Grouping, ReportBuilder> builders = new HashMap();
    protected FinanceTimesheetSearcher searcher;

    public TimesheetsDetailReportProvider(FinanceTimesheetSearcher yourSearcher) {
        this();
        this.searcher = yourSearcher;
    }

    public TimesheetsDetailReportProvider() {
        this.columns.put(FinanceTimesheet.Properties.PAYROLLID, "Payroll ID");
        this.columns.put(FinanceTimesheet.Properties.USER, "Name");
        this.columns.put(FinanceTimesheet.Properties.DEPARTMENT, "Department");
        this.columns.put(FinanceTimesheet.Properties.TRADING_DAY, "Date");
        this.columns.put(FinanceTimesheet.Properties.REPORTING_TIME_IN, "Start Date");
        this.columns.put(FinanceTimesheet.Properties.TIME_IN_HOUR_MIN, "Start Time");
        this.columns.put(FinanceTimesheet.Properties.REPORTING_TIME_OUT, "End Date");
        this.columns.put(FinanceTimesheet.Properties.TIME_OUT_HOUR_MIN, "End Time");
        this.columns.put(FinanceTimesheet.Properties.HOURS, "Hours");
        this.columns.put(FinanceTimesheet.Properties.TOTAL_PAY, "Pay");
        ArrayList comps = new ArrayList();
        List<PropertiedObject.Property<? extends PropertiedObject>> props = Collections.singletonList(FinanceTimesheet.Properties.USER);
        comps.add(new PropertyComparator(FinanceTimesheet.Properties.TRADING_DAY));
        comps.add(new PropertyComparator(props, (PropertiedObject.Property<? extends Comparable>)User.Properties.PAYROLL_ID));
        comps.add(new PropertyComparator(props, User.Properties.NAME));
        this.dateFirstComparator = new SequentialComparator<FinanceTimesheet>(comps);
    }

    public void setGrouping(Grouping grouping) {
        this.grouping = grouping;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.updateReportOrder(this.grouping);
        this.currentReportItems = this.getFilteredObjectListForReport(this.searcher.search());
        if (this.currentReportItems.isEmpty()) {
            return new JREmptyDataSource();
        }
        return new JRBeanCollectionDataSource(this.currentReportItems);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        this.report = this.getBuilder().buildJasperReport();
        this.report.setTitle("Detailed Timesheet Report");
        this.report.setSubtitle(this.getSubtitle());
        return this.report;
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        if (!this.builders.containsKey((Object)this.grouping)) {
            this.builders.put(this.grouping, this.createBuilder(this.grouping));
            this.addSubtotals(this.builders.get((Object)this.grouping), this.grouping);
        }
        return this.builders.get((Object)this.grouping);
    }

    protected void updateReportOrder(Grouping groupingToUse) {
        if (groupingToUse == Grouping.User) {
            this.getSearcher().setComparator(this.getSearcher().getDefaultComparator());
        } else if (groupingToUse == Grouping.Date) {
            this.getSearcher().setComparator(this.dateFirstComparator);
        }
    }

    private synchronized ReportBuilder createBuilder(Grouping groupingToUse) throws BuilderException {
        final ReportBuilder builder = new ReportBuilder(ReportBuilder.TemplateFormat.A4Landscape);
        builder.addBusinessLogoDetailHeaderAndFooterTemplate();
        this.getParameters().putAll(new HeaderSubReport().getParamsMap());
        builder.setTitle("Detailed Timesheet Report");
        builder.setSubtitle(this.getSubtitle());
        Style detailRightAlign = JasperReportHelper.rightAlignStyle(builder.getStyles().getColumnDetailStyle());
        Style headerRightAlign = JasperReportHelper.rightAlignStyle(builder.getStyles().getColumnHeaderStyle());
        Style headerLeftAlign = JasperReportHelper.leftAlignStyle(builder.getStyles().getColumnHeaderStyle());
        Style detailCenterAlign = JasperReportHelper.centerAlignStyle(builder.getStyles().getColumnDetailStyle());
        builder.addReportColumn(groupingToUse.getGroupingProperty(), this.columns.get(groupingToUse.getGroupingProperty()), null);
        for (Map.Entry<PropertiedObject.Property, String> column : this.columns.entrySet()) {
            if (column.getKey() == groupingToUse.getGroupingProperty()) continue;
            if (column.getKey() == FinanceTimesheet.Properties.REPORTING_TIME_IN || column.getKey() == FinanceTimesheet.Properties.REPORTING_TIME_OUT) {
                final SimpleDateFormat dateFormat = new SimpleDateFormat("d/MM/yy");
                final PropertiedObject.Property prop = column.getKey();
                builder.addInvisibleField(prop);
                AbstractColumn dateColumn = ColumnBuilder.getNew().setStyle(detailRightAlign).setHeaderStyle(headerRightAlign).setTitle(column.getValue()).setColumnProperty(builder.getPropertyColumn(prop).getColumnProperty()).setCustomExpression(new CustomExpression(){

                    public Object evaluate(Map fields, Map variables, Map parameters) {
                        Date columnValue = (Date)fields.get(prop.getName());
                        return columnValue != null ? dateFormat.format(columnValue) : "";
                    }

                    public String getClassName() {
                        return String.class.getName();
                    }
                }).build();
                builder.getReportBuilder().addColumn(dateColumn);
                continue;
            }
            builder.addReportColumn(column.getKey(), column.getValue(), null);
        }
        builder.addInvisibleField(FinanceTimesheet.Properties.ALTERED);
        AbstractColumn columnAltered = ColumnBuilder.getNew().setStyle(detailCenterAlign).setTitle("Time Punch Altered").setColumnProperty(builder.getPropertyColumn(FinanceTimesheet.Properties.ALTERED).getColumnProperty()).setCustomExpression(new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                Boolean columnValue = (Boolean)fields.get(builder.getPropertyColumn(FinanceTimesheet.Properties.ALTERED).getName().toLowerCase());
                if (columnValue != null && columnValue.booleanValue()) {
                    return "yes";
                }
                return "no";
            }

            public String getClassName() {
                return String.class.getName();
            }
        }).build();
        builder.getReportBuilder().addColumn(columnAltered);
        builder.getPropertyColumn(FinanceTimesheet.Properties.TIME_IN_HOUR_MIN).setStyle(detailRightAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.TIME_IN_HOUR_MIN).setHeaderStyle(headerRightAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.TIME_OUT_HOUR_MIN).setStyle(detailRightAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.TIME_OUT_HOUR_MIN).setHeaderStyle(headerRightAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.TRADING_DAY).setHeaderStyle(headerLeftAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.TRADING_DAY).setWidth(Integer.valueOf(60));
        builder.getPropertyColumn(FinanceTimesheet.Properties.PAYROLLID).setHeaderStyle(headerLeftAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.PAYROLLID).setWidth(Integer.valueOf(40));
        builder.getPropertyColumn(FinanceTimesheet.Properties.DEPARTMENT).setHeaderStyle(headerLeftAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.USER).setHeaderStyle(headerLeftAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.HOURS).setHeaderStyle(headerRightAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.HOURS).setStyle(detailRightAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.HOURS).setPattern("0.00");
        builder.getPropertyColumn(FinanceTimesheet.Properties.TOTAL_PAY).setHeaderStyle(headerRightAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.TOTAL_PAY).setStyle(detailRightAlign);
        builder.getPropertyColumn(FinanceTimesheet.Properties.TOTAL_PAY).setPattern("$0.00");
        builder.setUseGrandTotal(true);
        builder.getReportBuilder().setGrandTotalLegend("Grand Total");
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(FinanceTimesheet.Properties.HOURS), Double.class, DJCalculation.SUM);
        builder.addFooterCalculation((AbstractColumn)builder.getPropertyColumn(FinanceTimesheet.Properties.TOTAL_PAY), Double.class, DJCalculation.SUM);
        return builder;
    }

    private void addSubtotals(ReportBuilder builder, Grouping groupingToUse) {
        ReportBuilder.PropertyCalculation sumHrs = new ReportBuilder.PropertyCalculation(FinanceTimesheet.Properties.HOURS, DJCalculation.SUM);
        ReportBuilder.PropertyCalculation sumPay = new ReportBuilder.PropertyCalculation(FinanceTimesheet.Properties.TOTAL_PAY, DJCalculation.SUM);
        DJGroup group = builder.addGroupBy(groupingToUse.getGroupingProperty(), Arrays.asList(sumHrs, sumPay));
        DJGroupLabel footerLabel = new DJGroupLabel("Total: ", builder.getStyles().getFooterVariableStyle(), LabelPosition.LEFT);
        group.setFooterLabel(footerLabel);
        for (DJGroupVariable variable : group.getFooterVariables()) {
            variable.setStyle(JasperReportHelper.rightAlignStyle(builder.getStyles().getColumnDetailStyle()));
        }
        builder.getPropertyColumn(groupingToUse.getGroupingProperty()).setPosX(Integer.valueOf(0));
    }

    private List<FinanceTimesheet> getFilteredObjectListForReport(List<FinanceTimesheet> rawList) {
        ArrayList<FinanceTimesheet> result = new ArrayList();
        if (rawList.isEmpty()) {
            result = rawList;
        } else {
            for (FinanceTimesheet timesheet : rawList) {
                result.add(timesheet);
            }
        }
        return result;
    }

    public FinanceTimesheetSearcher getSearcher() {
        return this.searcher;
    }

    protected String getSubtitle() {
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getTradingDayDateRangeAdapter(), null);
        this.getHelper().appendSearchFilter(SB, "Departments", this.searcher.getDepartmentFilter());
        this.getHelper().appendSearchFilter(SB, "Users", this.searcher.getUserFilter());
        return SB.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }

    public static enum Grouping {
        User(FinanceTimesheet.Properties.USER),
        Date(FinanceTimesheet.Properties.TRADING_DAY);

        private final PropertiedObject.Property groupingProperty;

        private Grouping(PropertiedObject.Property groupingProperty) {
            this.groupingProperty = groupingProperty;
        }

        public PropertiedObject.Property getGroupingProperty() {
            return this.groupingProperty;
        }
    }
}

