/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.timesheet;

import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.finance.timesheet.TimesheetSummaryReport;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.searchers.reports.timesheet.FinanceTimesheetSearcher;
import ordermate.database.users.User;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.printing.HeaderSubReport;

public class TimesheetsSummaryReportProvider
extends AbstractReportProvider {
    private FinanceTimesheetSearcher searcher;
    private List<TimesheetSummaryReport> currentReportItems;
    private DynamicReport report;
    private final ReportBuilder builder = new ReportBuilder();

    public TimesheetsSummaryReportProvider(FinanceTimesheetSearcher timesheetSearcher) {
        this.searcher = timesheetSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        this.currentReportItems = this.getFilteredObjectListForReport(this.searcher.search());
        return new JRBeanCollectionDataSource(this.currentReportItems);
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        if (this.report == null) {
            this.report = this.getBuilder().buildJasperReport();
        }
        this.report.setTitle("Timesheet Summary Report");
        this.report.setSubtitle(this.getSubtitle());
        return this.report;
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        if (this.builder.getColumnCount() == 0) {
            this.initBuilder();
        }
        return this.builder;
    }

    private synchronized void initBuilder() throws BuilderException {
        this.builder.addBusinessLogoDetailHeaderAndFooterTemplate();
        this.getParameters().putAll(new HeaderSubReport().getParamsMap());
        this.builder.setTitle("Timesheet Summary Report");
        this.builder.setSubtitle(this.getSubtitle());
        Style detailRightAlign = JasperReportHelper.rightAlignStyle(this.builder.getStyles().getColumnDetailStyle());
        Style headerRightAlign = JasperReportHelper.rightAlignStyle(this.builder.getStyles().getColumnHeaderStyle());
        Style headerLeftAlign = JasperReportHelper.leftAlignStyle(this.builder.getStyles().getColumnHeaderStyle());
        this.builder.addReportColumns(Arrays.asList(TimesheetSummaryReport.Properties.PAYROLLID, TimesheetSummaryReport.Properties.USER, TimesheetSummaryReport.Properties.TOTAL_HOURS, TimesheetSummaryReport.Properties.TOTAL_PAY), "Payroll ID", "Name", "Hours", "Pay");
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.PAYROLLID).setHeaderStyle(headerLeftAlign);
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.PAYROLLID).setWidth(Integer.valueOf(40));
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.USER).setHeaderStyle(headerLeftAlign);
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_HOURS).setHeaderStyle(headerRightAlign);
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_HOURS).setStyle(detailRightAlign);
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_HOURS).setPattern("0.00");
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_PAY).setHeaderStyle(headerRightAlign);
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_PAY).setStyle(detailRightAlign);
        this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_PAY).setPattern("$0.00");
        this.builder.setUseGrandTotal(true);
        this.builder.getReportBuilder().setGrandTotalLegend("Grand Total");
        this.builder.addFooterCalculation((AbstractColumn)this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_HOURS), Double.class, DJCalculation.SUM);
        this.builder.addFooterCalculation((AbstractColumn)this.builder.getPropertyColumn(TimesheetSummaryReport.Properties.TOTAL_PAY), Double.class, DJCalculation.SUM);
    }

    private List<TimesheetSummaryReport> getFilteredObjectListForReport(List<FinanceTimesheet> rawList) {
        ArrayList<TimesheetSummaryReport> result = new ArrayList<TimesheetSummaryReport>();
        for (FinanceTimesheet timesheet : rawList) {
            TimesheetSummaryReport ts = this.findUserInTimesheetList(result, timesheet.getUser());
            if (ts != null) {
                ts.setTotalSeconds(ts.getTotalSeconds().add(BigDecimal.valueOf(timesheet.getTotalSeconds())));
                ts.setTotalPay(ts.getTotalPay().add(BigDecimal.valueOf(timesheet.getTotalPay().doubleValue())));
                continue;
            }
            ts = new TimesheetSummaryReport();
            ts.setUser(timesheet.getUser());
            ts.setDepartment(timesheet.getDepartment());
            ts.setTotalSeconds(BigDecimal.valueOf(timesheet.getTotalSeconds()));
            ts.setTotalPay(BigDecimal.valueOf(timesheet.getTotalPay().doubleValue()));
            result.add(ts);
        }
        return result;
    }

    private TimesheetSummaryReport findUserInTimesheetList(List<TimesheetSummaryReport> list, User user) {
        for (TimesheetSummaryReport timesheet : list) {
            if (!timesheet.getUser().getID().equals(user.getID())) continue;
            return timesheet;
        }
        return null;
    }

    private String getSubtitle() {
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getTradingDayDateRangeAdapter(), null);
        this.getHelper().appendSearchFilter(SB, "Departments", this.searcher.getDepartmentFilter());
        this.getHelper().appendSearchFilter(SB, "Users", this.searcher.getUserFilter());
        return SB.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

