/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.tips;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.finance.transactions.FinanceUnit;

public class TipsReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Date tradingDay;
    private String shift;
    private Price total;
    private Price sales;
    private Price tips;
    private byte[] financeUnitRawResults;
    private Map<String, Price> financeUnitResults;
    private Price totalCardTips;
    private Double tipsOfSales;
    private String financeUnits;

    public Object getFinanceUnitRawResults() {
        return this.financeUnitRawResults;
    }

    public Map<String, Price> getFinanceUnitResults() {
        String[] rawData = new String(this.financeUnitRawResults).split(",");
        this.financeUnitResults = new HashMap<String, Price>();
        List<FinanceUnit> units = FinanceUnit.getActiveTipsFinanceUnits();
        for (int i = 0; i < rawData.length; ++i) {
            this.financeUnitResults.put(units.get(i).getLabel(), new Price(Double.parseDouble(rawData[i]), 0.0));
        }
        return this.financeUnitResults;
    }

    public Price getFinanceUnitResult(String financeUnit) {
        return this.getFinanceUnitResults().get(financeUnit);
    }

    public void setFinanceUnitRawResults(byte[] financeUnitResults) {
        this.financeUnitRawResults = financeUnitResults;
    }

    public String getShift() {
        return this.shift;
    }

    public void setShift(String shift) {
        this.shift = shift;
    }

    public Date getTradingDay() {
        return this.tradingDay;
    }

    public void setTradingDay(Date tradingDay) {
        this.tradingDay = tradingDay;
    }

    public Price getTotal() {
        return this.total;
    }

    public void setTotal(Price total) {
        this.total = total;
    }

    public Price getSales() {
        return this.sales;
    }

    public void setSales(Price sales) {
        this.sales = sales;
    }

    public Price getTips() {
        return this.tips;
    }

    public void setTips(Price tips) {
        this.tips = tips;
    }

    public Price getTotalCardTips() {
        return this.totalCardTips;
    }

    public void setTotalCardTips(Price totalCardTips) {
        this.totalCardTips = totalCardTips;
    }

    public Double getTipsOfSales() {
        return this.tipsOfSales;
    }

    public void setTipsOfSales(Double tipsOfSales) {
        this.tipsOfSales = tipsOfSales;
    }

    public String getFinanceUnits() {
        return this.financeUnits;
    }

    public void setFinanceUnits(String financeUnits) {
        this.financeUnits = financeUnits;
    }

    public String getDateString() {
        return DateTimeUtils.getDateOfBirthFormat().format(this.tradingDay);
    }

    public List<Object> getDataAsList() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(this.getDateString());
        data.add(this.shift);
        data.add(this.total);
        data.add(this.sales);
        data.add(this.tips);
        for (Price finData : this.getFinanceUnitResults().values()) {
            data.add(finData);
        }
        data.add(this.totalCardTips);
        data.add(this.tipsOfSales);
        return data;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Date> TRADING_DAY;
        public PropertiedObject.Property<String> SHIFT;
        public PropertiedObject.Property<Price> TOTAL;
        public PropertiedObject.Property<Price> SALES;
        public PropertiedObject.Property<Price> TIPS;
        public PropertiedObject.Property<byte[]> FINANCE_UNIT_RAW_RESULTS;
        public PropertiedObject.Property<Price> TOTAL_CARD_TIPS;
        public PropertiedObject.Property<Double> TIPS_OF_SALES;
        public PersistentObject.DerivedProperty<String> DATE_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)TipsReport.class), "dateString");
    }
}

