/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.tips;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Rotation;
import ar.com.fdvs.dj.domain.constants.Stretching;
import ar.com.fdvs.dj.domain.constants.VerticalAlign;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.reports.tips.TipsReport;
import ordermate.database.reports.tips.TipsReportSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.GenericBiListTableModel;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class TipsReportProvider
extends AbstractReportProvider {
    private static final String REPORT_TITLE = "Tips Report";
    private TipsReportSearcher searcher;
    private List<ColumnFormat> unitColumnFormats = new ArrayList<ColumnFormat>();

    public TipsReportProvider(TipsReportSearcher theSearcher) {
        this.searcher = theSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRTableModelDataSource(new GenericBiListTableModel(this.getColumns(), this.getPDFData()));
    }

    private List<List<Object>> getPDFData() {
        List reports = this.searcher.search();
        ArrayList<List<Object>> toReturn = new ArrayList<List<Object>>();
        for (TipsReport report : reports) {
            toReturn.add(report.getDataAsList());
        }
        return toReturn;
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle(), ReportBuilder.TemplateFormat.A4Landscape);
        builder.getReportBuilder().setPageSizeAndOrientation(Page.Page_A4_Landscape());
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle(REPORT_TITLE);
        builder.getStyles().getColumnHeaderStyle().setStreching(Stretching.RELATIVE_TO_TALLEST_OBJECT);
        builder.getStyles().getColumnHeaderStyle().setStretchWithOverflow(false);
        builder.getStyles().getColumnHeaderStyle().setRotation(Rotation.RIGHT);
        builder.getStyles().getColumnHeaderStyle().setBackgroundColor(Color.BLACK);
        builder.getStyles().getColumnHeaderStyle().getFont().setFontSize(6);
        builder.getStyles().getColumnDetailStyle().getFont().setFontSize(6);
        builder.getStyles().getColumnDetailStyle().setVerticalAlign(VerticalAlign.TOP);
        Style rotatedStyle = builder.getStyles().getColumnHeaderStyle();
        rotatedStyle.setBackgroundColor(Color.GRAY);
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getDateRangeFilter(), null);
        this.getHelper().appendSearchFilter(SB, "Shift", this.searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.searcher.getSalesLocationFilter());
        builder.setSubtitle(SB.toString());
        builder.getReportBuilder().setHeaderHeight(50);
        builder.addReportColumn(TipsReport.Properties.DATE_STRING, "Trading Day", null);
        builder.addReportColumn(TipsReport.Properties.SALES, Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.addReportColumn(TipsReport.Properties.TIPS, Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.addReportColumn(TipsReport.Properties.TOTAL, Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        if (this.searcher.isShowFinanceUnits()) {
            for (FinanceUnit unit : FinanceUnit.getActiveTipsFinanceUnits()) {
                SimpleColumn col = JasperReportHelper.createSimpleColumn(unit.getLabel(), String.class);
                col.setHeaderStyle(rotatedStyle);
                col.getStyle().getFont().setFontSize(6);
                col.getStyle().setVerticalAlign(VerticalAlign.TOP);
                col.setWidth(Integer.valueOf(33));
                builder.getReportBuilder().addColumn((AbstractColumn)col);
            }
        }
        builder.addReportColumn(TipsReport.Properties.TOTAL_CARD_TIPS, "$0.00");
        builder.addReportColumn(TipsReport.Properties.TIPS_OF_SALES, "0.#%");
        builder.getReportBuilder().setGrandTotalLegend("TOTALS: ");
        builder.getReportBuilder().setGrandTotalLegendStyle(this.getTotalTagStyle());
        builder.getReportBuilder().setUseFullPageWidth(true);
        builder.getReportBuilder().setAllowDetailSplit(true);
        return builder;
    }

    private Style getTotalTagStyle() {
        Style total = this.getNewTotalLineStyle();
        total.setHorizontalAlign(HorizontalAlign.LEFT);
        return total;
    }

    private Style getNewTotalLineStyle() {
        Style totalLineStyle = new OrderMateOmorphosReportStyle().getColumnDetailStyle();
        totalLineStyle.getFont().setBold(true);
        totalLineStyle.setTextColor(Color.BLACK);
        totalLineStyle.setHorizontalAlign(HorizontalAlign.RIGHT);
        return totalLineStyle;
    }

    public final ColumnFormat[] getColumnFormat() {
        ArrayList<ColumnFormat> columnFormats = new ArrayList<ColumnFormat>();
        columnFormats.addAll(Arrays.asList(new PropertyColumnFormat(TipsReport.Properties.DATE_STRING), new PropertyColumnFormat(TipsReport.Properties.SHIFT), new PropertyColumnFormat(TipsReport.Properties.TOTAL), new PropertyColumnFormat(TipsReport.Properties.SALES), new PropertyColumnFormat(TipsReport.Properties.TIPS)));
        columnFormats.addAll(this.unitColumnFormats);
        columnFormats.addAll(Arrays.asList(new PropertyColumnFormat(TipsReport.Properties.TOTAL_CARD_TIPS), new PropertyColumnFormat(TipsReport.Properties.TIPS_OF_SALES).setFormatter(new DecimalFormat("0.0%"))));
        return columnFormats.toArray(new ColumnFormat[0]);
    }

    public List<String> getColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("dateString");
        columns.add("shift");
        columns.add("total");
        columns.add("sales");
        columns.add("tips");
        for (FinanceUnit unit : FinanceUnit.getActiveTipsFinanceUnits()) {
            columns.add(unit.getLabel());
        }
        columns.add("totalCardTips");
        columns.add("tipsOfSales");
        return columns;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }

    public TipsReportSearcher getSearcher() {
        return this.searcher;
    }

    public List<ColumnFormat> getUnitColumnFormats() {
        return this.unitColumnFormats;
    }
}

