/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.tips;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.oquery.search.PropertySearcher;
import au.com.ordermate.oquery.search.annotation.FilterConfig;
import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.MultiOptionSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.filters.OptimisedDateRangeSearchFilter;
import ordermate.database.filters.TradingDayDateRangeFilterAdapter;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.tips.TipsReport;
import ordermate.database.reports.tips.TipsReportProvider;
import ordermate.database.sales.itemfilter.TimeSearchFilter;
import ordermate.reports.table.AbstractColumnFormat;

public class TipsReportSearcher
extends PropertySearcher<TipsReport> {
    private final IRangedQuerySearchFilter<Date> dateRangeFilter;
    private final IRangedQuerySearchFilter<Date> tradingDayDateRangeAdapter;
    private final TimeSearchFilter timeRangeSearch;
    private final MultiOptionJoinSearchFilter shiftFilter;
    private final MultiOptionSearchFilter<SalesLocation> salesLocationFilter;
    private boolean groupByShift;
    private boolean showFinanceUnits;
    private TipsReportProvider tipsReportProvider;

    public TipsReportSearcher() {
        super(TipsReport.class);
        this.dateRangeFilter = new RangeJoinSearchFilter<Date>(new OptimisedDateRangeSearchFilter(TradingDay.Properties.DATE, SQLDateType.DATE), FinanceTransaction.Properties.TRADING_DAY);
        this.tradingDayDateRangeAdapter = new TradingDayDateRangeFilterAdapter(this.dateRangeFilter);
        this.timeRangeSearch = new TimeSearchFilter(FinanceTransaction.Properties.CREATION_TIME);
        this.shiftFilter = new MultiOptionJoinSearchFilter(FinanceTransaction.Properties.SHIFT, Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.ID);
        this.salesLocationFilter = new MultiOptionSearchFilter<SalesLocation>(FinanceTransaction.Properties.SALES_LOCATION);
        this.groupByShift = false;
        this.showFinanceUnits = false;
        this.tipsReportProvider = new TipsReportProvider(this);
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        this.addSearchFilter(this.salesLocationFilter);
        this.getDateRangeFilter().setStart(DateTimeUtils.getOneMonthAgoCal().getTime());
        this.getDateRangeFilter().setEnd(new Date());
        for (FinanceUnit unit : FinanceUnit.getActiveTipsFinanceUnits()) {
            this.tipsReportProvider.getUnitColumnFormats().add(new AbstractColumnFormat(unit.getLabel(), Price.class){

                @Override
                public Object resolveColumnValue(Object object) {
                    return ((TipsReport)object).getFinanceUnitResult(this.getName());
                }
            });
        }
    }

    @Override
    protected ObjectQuery getBaseQuery() {
        ObjectQuery query = Query.select(TradingDay.Properties.DATE);
        query.select(FinanceTransaction.Properties.CREATION_TIME);
        query.select(ConfigShift.Properties.LABEL);
        if (this.groupByShift) {
            query.groupBy(ConfigShift.Properties.LABEL);
            query.orderBy(ConfigShift.Properties.LABEL);
        }
        String finQuery = "";
        String joinQuery = "CONCAT(";
        for (FinanceUnit unit : FinanceUnit.getActiveTipsFinanceUnits()) {
            String selectFunc = "SUM(IF(finance_transaction.fk_finance_unit = " + unit.getID() + ", finance_transaction.tip, 0))";
            if (unit.isUsesEftpos()) {
                finQuery = finQuery + selectFunc + "+";
            }
            joinQuery = joinQuery + selectFunc + ", ',' ,";
        }
        String sales = "SUM(finance_transaction.amount_paid)";
        query.selectFunc(sales + " as sales");
        String tips = "SUM(finance_transaction.tip)";
        query.selectFunc(tips + " as tips");
        String total = "(" + sales + " + " + tips + ")";
        query.selectFunc(total + " as total");
        query.selectFunc("(" + tips + " / " + total + ") AS tipsOfSales");
        finQuery = finQuery.substring(0, finQuery.length() - 1);
        joinQuery = joinQuery.substring(0, joinQuery.length() - 1);
        joinQuery = joinQuery + ") AS financeUnitRawResults";
        query.selectFunc("(" + finQuery + ") as totalCardTips");
        query.selectFunc(joinQuery);
        query.linkUsing(FinanceTransaction.Properties.TRADING_DAY, TradingDay.Properties.ID);
        query.linkUsing(FinanceTransaction.Properties.SHIFT, Shift.Properties.ID);
        query.linkUsing(Shift.Properties.CONFIG_SHIFT, ConfigShift.Properties.ID);
        query.whereFunction("finance_transaction.system_state = 'active'");
        query.orderBy(FinanceTransaction.Properties.TRADING_DAY);
        query.groupBy(FinanceTransaction.Properties.TRADING_DAY);
        return query;
    }

    public void setGroupByShift(boolean groupByShift) {
        this.groupByShift = groupByShift;
    }

    public void setShowFinanceUnits(boolean showFinanceUnits) {
        this.showFinanceUnits = showFinanceUnits;
    }

    public boolean isGroupByShift() {
        return this.groupByShift;
    }

    public boolean isShowFinanceUnits() {
        return this.showFinanceUnits;
    }

    @FilterConfig(name="Shift", dataType=ConfigShift.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, priority=false, sequence=5)
    public final MultiOptionJoinSearchFilter<ConfigShift> getShiftFilter() {
        this.addSearchFilter(this.shiftFilter);
        return this.shiftFilter;
    }

    @FilterConfig(name="Time", dataType=Date.class, dateType=SQLDateType.TIME, plural=FilterConfig.Plural.Ranged, nullAllowed=true, priority=true, sequence=2)
    public final TimeSearchFilter getTimeRangeFilter() {
        this.addSearchFilter(this.timeRangeSearch);
        return this.timeRangeSearch;
    }

    @FilterConfig(name="Date Range", dateType=SQLDateType.DATE, dataType=Date.class, plural=FilterConfig.Plural.Ranged, nullAllowed=false, priority=true, sequence=1)
    public final IRangedQuerySearchFilter<Date> getDateRangeFilter() {
        this.addSearchFilter(this.dateRangeFilter);
        return this.dateRangeFilter;
    }

    @FilterConfig(name="Sales Location", dataType=SalesLocation.class, plural=FilterConfig.Plural.Multiple, nullAllowed=true, sequence=10)
    public final MultiOptionSearchFilter<SalesLocation> getSalesLocationFilter() {
        this.addSearchFilter(this.salesLocationFilter);
        return this.salesLocationFilter;
    }

    public final IRangedQuerySearchFilter<Date> getTradingDayDateRangeAdapter() {
        this.addSearchFilter(this.tradingDayDateRangeAdapter);
        return this.tradingDayDateRangeAdapter;
    }

    public void setStartDate(Date startDate) {
        this.getDateRangeFilter().setStart(startDate);
    }

    public void setEndDate(Date endDate) {
        this.getDateRangeFilter().setEnd(endDate);
    }

    public TipsReportProvider getTipsReportProvider() {
        return this.tipsReportProvider;
    }
}

