/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.transaction;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.constants.HorizontalAlign;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.DJGroupVariable;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.finance.Shift;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.searchers.finance.FinanceTransactionSearcher;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateTimeExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class FinanceTransactionReportProvider
extends AbstractReportProvider {
    private SearcherDataSourceProvider<FinanceTransactionSearcher> dataProvider;
    private FinanceTransactionSearcher searcher;

    public FinanceTransactionReportProvider(FinanceTransactionSearcher yourSearcher) {
        this.searcher = yourSearcher;
        this.dataProvider = new SearcherDataSourceProvider<FinanceTransactionSearcher>(this.searcher);
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return this.dataProvider.getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        DynamicReport report = this.getBuilder().buildJasperReport();
        return report;
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.getReportBuilder().setPageSizeAndOrientation(Page.Page_A4_Landscape());
        builder.setTitle("Finance Transaction Report");
        String subtitle = this.makeSubtitle();
        builder.setSubtitle(subtitle);
        builder.addMinimalistBusinessDetails();
        builder.getReportBuilder().setAllowDetailSplit(true);
        builder.getReportBuilder().setHeaderHeight(20);
        builder.getStyles().getColumnHeaderStyle().getFont().setFontSize(6);
        builder.getStyles().getColumnDetailStyle().getFont().setFontSize(6);
        builder.getStyles().getColumnDetailStyle().setHorizontalAlign(HorizontalAlign.RIGHT);
        builder.getReportBuilder().setAllowDetailSplit(false);
        builder.getStyles().getFooterVariableStyle().setFont(Font.ARIAL_SMALL_BOLD);
        builder.setUseGrandTotal(true);
        builder.getReportBuilder().setGrandTotalLegend("Total");
        builder.getReportBuilder().setGrandTotalLegendStyle(builder.getStyles().getFooterVariableStyle());
        builder.addReportColumn(FinanceTransaction.Properties.SHIFT, null);
        DateTimeExpressionBuilder dateExpression = new DateTimeExpressionBuilder(DateTimeUtils.getDateTimeFormat());
        builder.getCustomExpressionRegister().put(Date.class, dateExpression);
        builder.addReportColumn(FinanceTransaction.Properties.CREATION_TIME, null);
        if (!"ACTIVE".equals(this.searcher.getSystemStateFilter().getSearchValue())) {
            builder.addReportColumn(FinanceTransaction.Properties.SYSTEM_STATE, "State", null);
            builder.getPropertyColumn(FinanceTransaction.Properties.SYSTEM_STATE).setWidth(Integer.valueOf(30));
        }
        builder.addReportColumn(FinanceTransaction.Properties.ID, "Txn ID", null);
        builder.addReportColumn(FinanceTransaction.Properties.CASH_DRAWER, null);
        CustomExpression eftposExpression = new CustomExpression(){

            public Object evaluate(Map fields, Map variables, Map parameters) {
                FinanceTransaction txn = (FinanceTransaction)FinanceTransactionReportProvider.this.dataProvider.getCurrentReportList().get((Integer)variables.get("REPORT_COUNT") - 1);
                if (txn instanceof EftposTransaction) {
                    if (((EftposTransaction)txn).getVirtualEftpos() != null) {
                        return ((EftposTransaction)txn).getVirtualEftpos().getLabel();
                    }
                    return "None";
                }
                return "";
            }

            public String getClassName() {
                return String.class.getName();
            }
        };
        ExpressionColumn eftposCol = new ExpressionColumn();
        eftposCol.setStyle(builder.getStyles().getColumnDetailStyle());
        eftposCol.setExpression(eftposExpression);
        eftposCol.setTitle("Eftpos");
        eftposCol.setBlankWhenNull(Boolean.TRUE);
        eftposCol.setWidth(Integer.valueOf(40));
        ColumnProperty colProp = new ColumnProperty();
        eftposCol.setColumnProperty(colProp);
        builder.getReportBuilder().addColumn((AbstractColumn)eftposCol);
        builder.addReportColumn(FinanceTransaction.Properties.SUB_TYPE, "Unit", null);
        builder.addReportColumn(FinanceTransaction.Properties.TRIMMED_REF, "Ref", null);
        builder.addReportColumn(FinanceTransaction.Properties.PAID_EX_SURCH_EX_TIP, "Paid Ex Surch Ex Tip", null);
        builder.addReportColumn(FinanceTransaction.Properties.SURCHARGE, "Surch", null);
        builder.addReportColumn(FinanceTransaction.Properties.TIP, null);
        builder.addReportColumn(FinanceTransaction.Properties.CASH_OUT, null);
        builder.addReportColumn(FinanceTransaction.Properties.PAID_EX_SURCH_INC_TIP, "Paid Inc Tip", null);
        builder.addReportColumn(FinanceTransaction.Properties.PAID, "Paid Inc Surch", null);
        builder.addReportColumn(FinanceTransaction.Properties.PAID_TOTAL, "Txn Total", null);
        ArrayList<ReportBuilder.PropertyCalculation> calcs = new ArrayList<ReportBuilder.PropertyCalculation>();
        DJGroup group = builder.addGroupBy(FinanceTransaction.Properties.SHIFT, calcs);
        group.addFooterVariable(new DJGroupVariable((AbstractColumn)builder.getPropertyColumn(FinanceTransaction.Properties.PAID_TOTAL), (CustomExpression)new ActiveOnlySummator(FinanceTransaction.Properties.PAID_TOTAL)));
        group.addFooterVariable(new DJGroupVariable((AbstractColumn)builder.getPropertyColumn(FinanceTransaction.Properties.PAID_EX_SURCH_INC_TIP), (CustomExpression)new ActiveOnlySummator(FinanceTransaction.Properties.PAID_EX_SURCH_INC_TIP)));
        group.addFooterVariable(new DJGroupVariable((AbstractColumn)builder.getPropertyColumn(FinanceTransaction.Properties.PAID_EX_SURCH_EX_TIP), (CustomExpression)new ActiveOnlySummator(FinanceTransaction.Properties.PAID_EX_SURCH_EX_TIP)));
        group.addFooterVariable(new DJGroupVariable((AbstractColumn)builder.getPropertyColumn(FinanceTransaction.Properties.PAID), (CustomExpression)new ActiveOnlySummator(FinanceTransaction.Properties.PAID)));
        group.addFooterVariable(new DJGroupVariable((AbstractColumn)builder.getPropertyColumn(FinanceTransaction.Properties.SURCHARGE), (CustomExpression)new ActiveOnlySummator(FinanceTransaction.Properties.SURCHARGE)));
        group.addFooterVariable(new DJGroupVariable((AbstractColumn)builder.getPropertyColumn(FinanceTransaction.Properties.CASH_OUT), (CustomExpression)new ActiveOnlySummator(FinanceTransaction.Properties.CASH_OUT)));
        group.addFooterVariable(new DJGroupVariable((AbstractColumn)builder.getPropertyColumn(FinanceTransaction.Properties.TIP), (CustomExpression)new ActiveOnlySummator(FinanceTransaction.Properties.TIP)));
        Integer PRICE_WIDTH = 30;
        PropertyColumn col = builder.getPropertyColumn(FinanceTransaction.Properties.ID);
        col.setWidth(PRICE_WIDTH);
        col = builder.getPropertyColumn(FinanceTransaction.Properties.CREATION_TIME);
        col.setWidth(Integer.valueOf(40));
        col = builder.getPropertyColumn(FinanceTransaction.Properties.TRIMMED_REF);
        col.setWidth(PRICE_WIDTH);
        col = builder.getPropertyColumn(FinanceTransaction.Properties.CASH_OUT);
        col.setWidth(PRICE_WIDTH);
        col = builder.getPropertyColumn(FinanceTransaction.Properties.SURCHARGE);
        col.setWidth(PRICE_WIDTH);
        col = builder.getPropertyColumn(FinanceTransaction.Properties.PAID);
        col.setWidth(PRICE_WIDTH);
        col = builder.getPropertyColumn(FinanceTransaction.Properties.TIP);
        col.setWidth(PRICE_WIDTH);
        col = builder.getPropertyColumn(FinanceTransaction.Properties.PAID_TOTAL);
        col.setWidth(PRICE_WIDTH);
        col = builder.getPropertyColumn(FinanceTransaction.Properties.PAID_EX_SURCH_EX_TIP);
        col.setWidth(PRICE_WIDTH);
        col = builder.getPropertyColumn(FinanceTransaction.Properties.PAID_EX_SURCH_INC_TIP);
        col.setWidth(PRICE_WIDTH);
        group.setReprintHeaderOnEachPage(Boolean.TRUE);
        group.setHeaderHeight(Integer.valueOf(18));
        return builder;
    }

    private String makeSubtitle() {
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendRangeSearchFilter(SB, "Date", this.searcher.getTradingDayFilter(), this.getHelper().getDateFormat());
        this.getHelper().appendCollection(SB, "Terminals", this.searcher.getTerminalFilter().getSelectedOptions());
        this.getHelper().appendCollection(SB, "Sales Location", this.searcher.getSalesLocationFilter().getSelectedOptions());
        this.getHelper().appendCollection(SB, "Users", this.searcher.getUserFilter().getSelectedOptions());
        this.getHelper().appendCollection(SB, "Eftpos", this.searcher.getEftposFilter().getSelectedOptions());
        this.getHelper().appendSearchFilter(SB, "State", this.searcher.getSystemStateFilter());
        this.getHelper().appendSearchFilter(SB, "Account Type", this.searcher.getAccountTypeFilter());
        this.getHelper().appendSearchFilter(SB, "Shift", this.searcher.getShiftFilter());
        this.getHelper().appendSearchFilter(SB, "Source", this.searcher.getSourceFilter());
        this.getHelper().appendSearchFilter(SB, "Reference", this.searcher.getReferenceFilter());
        this.getHelper().appendSearchFilter(SB, "Type", this.searcher.getTypeFilter());
        this.getHelper().appendSearchFilter(SB, "Unit", this.searcher.getUnitFilter());
        this.getHelper().appendSearchFilter(SB, "Cashdrawer", this.searcher.getCashdrawerFilter());
        return SB.toString();
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }

    class ActiveOnlySummator
    implements CustomExpression {
        private PropertiedObject.Property prop;
        private Shift shift;
        private int index = 0;

        public ActiveOnlySummator(PropertiedObject.Property<Price> prop) {
            this.prop = prop;
        }

        public Object evaluate(Map fields, Map variables, Map parameters) {
            if (this.shift == null) {
                this.shift = ((FinanceTransaction)FinanceTransactionReportProvider.this.dataProvider.getCurrentReportList().get(0)).getShift();
            } else {
                for (int i = this.index + 1; i < FinanceTransactionReportProvider.this.dataProvider.getCurrentReportList().size(); ++i) {
                    if (this.shift == ((FinanceTransaction)FinanceTransactionReportProvider.this.dataProvider.getCurrentReportList().get(i)).getShift()) continue;
                    this.shift = ((FinanceTransaction)FinanceTransactionReportProvider.this.dataProvider.getCurrentReportList().get(i)).getShift();
                    this.index = i;
                    break;
                }
            }
            Price value = Price.ZERO_DOLLAR;
            String state = (String)FinanceTransactionReportProvider.this.searcher.getSystemStateFilter().getSearchValue();
            for (Object txn : FinanceTransactionReportProvider.this.dataProvider.getCurrentReportList()) {
                if (!this.shift.equals(((FinanceTransaction)txn).getShift()) || state != null && !"ACTIVE".equals(((FinanceTransaction)txn).getSystemState())) continue;
                value = value.add((Price)this.prop.resolveValue(txn));
            }
            return value.toString();
        }

        public String getClassName() {
            return String.class.getName();
        }
    }
}

