/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.vouchers;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.searchers.reports.vouchers.VoucherSearcher;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.customexpressions.DateExpressionBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class VoucherSummaryReportProvider
extends AbstractReportProvider {
    private VoucherSearcher searcher;

    public VoucherSummaryReportProvider(VoucherSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new SearcherDataSourceProvider<VoucherSearcher>(this.searcher).getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder();
        builder.setTitle("Voucher Summary");
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendRangeSearchFilter(SB, "Created", this.searcher.getCreationDateRangeFilter(), this.getHelper().getDateFormat());
        this.getHelper().appendRangeSearchFilter(SB, "Activated", this.searcher.getActivationDateRangeFilter(), this.getHelper().getDateFormat());
        this.getHelper().appendSearchFilter(SB, "First Name", this.searcher.getFirstNameFilter());
        this.getHelper().appendSearchFilter(SB, "Last Name", this.searcher.getLastNameFilter());
        this.getHelper().appendSearchFilter(SB, "UUID Starts With", this.searcher.getUuidPrefixFilter());
        builder.setSubtitle(SB.toString());
        builder.addReportColumn(GiftVoucher.Properties.UNIQUE_ID, null);
        builder.addReportColumn(GiftVoucher.Properties.CUSTOMER, null);
        builder.addReportColumn(GiftVoucher.Properties.CREATION_DATE, "dd/MM/yyyy ");
        builder.getCustomExpressionRegister().put(Date.class, new DateExpressionBuilder(DateTimeUtils.getSimpleTimeFormat()));
        builder.addReportColumn(GiftVoucher.Properties.CREATION_TIME, "h:mm a");
        builder.addReportColumn(GiftVoucher.Properties.CACHED_VALUE, "Charge Left");
        builder.addReportColumn(GiftVoucher.Properties.SYSTEM_STATE, "State");
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

