/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.vouchers;

import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.searchers.reports.vouchers.VoucherTransactionSearcher;
import ordermate.internationalization.Internationalization;
import ordermate.reports.dynamicjasper.OrderMateMinimalistStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;
import ordermate.reports.impl.SearcherDataSourceProvider;

public class VoucherTransactionReportProvider
extends AbstractReportProvider {
    private VoucherTransactionSearcher searcher;

    public VoucherTransactionReportProvider(VoucherTransactionSearcher yourSearcher) {
        this.searcher = yourSearcher;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new SearcherDataSourceProvider<VoucherTransactionSearcher>(this.searcher).getDataSource();
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateMinimalistStyle());
        builder.setTitle("Voucher Transaction Summary");
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendSearchFilter(SB, "Day", this.searcher.getTradingDayFilter());
        this.getHelper().appendDatedSubtitle(SB, this.searcher.getTradingDayDateRangeAdapter(), null);
        this.getHelper().appendRangeSearchFilter(SB, "Created", this.searcher.getCreatedDayRangeFilter(), this.getHelper().getDateFormat());
        this.getHelper().appendSearchFilter(SB, "First Name", this.searcher.getFirstNameFilter());
        this.getHelper().appendSearchFilter(SB, "Last Name", this.searcher.getLastNameFilter());
        this.getHelper().appendSearchFilter(SB, "UUID Starts With", this.searcher.getUuidPrefixFilter());
        this.getHelper().appendSearchFilter(SB, "Voucher", this.searcher.getVoucherFilter());
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.searcher.getSalesLocationFilter());
        builder.setSubtitle(SB.toString());
        builder.addReportColumn(GiftVoucherTransaction.Properties.TRADING_DAY, null);
        builder.addReportColumn(GiftVoucherTransaction.Properties.UUID, null);
        builder.addReportColumn(GiftVoucherTransaction.Properties.VOUCHER_TRANSACTION_TYPE, null);
        builder.addReportColumn(GiftVoucherTransaction.Properties.AMOUNT, Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.addReportColumn(GiftVoucherTransaction.Properties.VOUCHER_BALANCE, "Running Total", Internationalization.getLiteralFor("DOLLAR_SIGN") + "0.00");
        builder.addReportColumn(GiftVoucherTransaction.Properties.AUTH_ID, "Auth ID", null);
        builder.addReportColumn(GiftVoucherTransaction.Properties.SYSTEM_STATE, "State", null);
        builder.addReportColumn(GiftVoucherTransaction.Properties.EXPIRY_DATE, "Expiry Date", "dd/MM/yyyy");
        builder.addReportColumn(GiftVoucherTransaction.Properties.EXPIRY_TIME, "Expiry Time", "hh:mm");
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return null;
    }
}

