/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports.weekdaysales;

import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.BuilderException;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import au.com.ordermate.util.Price;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import ordermate.database.reports.ReportProviderHelper;
import ordermate.database.reports.config.custom.JasperReportHelper;
import ordermate.database.searchers.reports.weekdaysales.WeekdaySalesByHourCompilerTableModel;
import ordermate.database.searchers.reports.weekdaysales.WeekdaySalesByHourReportCompiler;
import ordermate.reports.dynamicjasper.OrderMateOmorphosReportStyle;
import ordermate.reports.dynamicjasper.ReportBuilder;
import ordermate.reports.dynamicjasper.reportbuilder.AbstractReportProvider;

public class WeekdaySalesByHourReportProvider
extends AbstractReportProvider {
    private WeekdaySalesByHourReportCompiler compiler;

    public WeekdaySalesByHourReportProvider(WeekdaySalesByHourReportCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public JRRewindableDataSource getDataSource() {
        return new JRTableModelDataSource((TableModel)new WeekdaySalesByHourCompilerTableModel(this.compiler));
    }

    @Override
    protected DynamicReport getReport() throws BuilderException {
        return this.getBuilder().buildJasperReport();
    }

    @Override
    public ReportBuilder getBuilder() throws BuilderException {
        ReportBuilder builder = new ReportBuilder(new OrderMateOmorphosReportStyle(){

            @Override
            protected Style constructFooterVariableStyle() {
                Style style = super.constructFooterVariableStyle();
                style.setFont(Font.ARIAL_SMALL);
                return style;
            }

            @Override
            protected Style constructGroupedDetailStyle() {
                Style style = super.constructGroupedDetailStyle();
                style.setFont(Font.ARIAL_BIG_BOLD);
                return style;
            }
        });
        this.getParameters().putAll(builder.addBusinessLogoDetailHeaderAndFooterTemplate());
        builder.setTitle("Weekday Sales by Hour");
        StringBuilder SB = new StringBuilder();
        this.getHelper().appendDatedSubtitle(SB, this.compiler.getSearcher().getDateRangeFilter(), null);
        this.getHelper().appendSearchFilter(SB, "Sales Location", this.compiler.getSearcher().getSalesLocationFilter());
        builder.setSubtitle(SB.toString());
        builder.setUseGrandTotal(true);
        DecimalFormat df = new DecimalFormat("0.00");
        for (int i = 0; i < this.compiler.getColumnNames().size(); ++i) {
            String name = this.compiler.getColumnNames().get(i);
            ColumnProperty prop = null;
            prop = i == 0 ? new ColumnProperty(name, String.class) : new ColumnProperty(name, Double.class);
            SimpleColumn column = new SimpleColumn();
            column.setHeaderStyle(JasperReportHelper.centerAlignStyle(builder.getStyles().getColumnHeaderStyle()));
            column.setColumnProperty(prop);
            column.setName(name);
            column.setTitle(name);
            builder.getReportBuilder().addColumn((AbstractColumn)column);
            if (i <= 0) continue;
            column.setStyle(JasperReportHelper.rightAlignStyle(builder.getStyles().getColumnDetailStyle()));
            column.setTextFormatter((Format)df);
            builder.addFooterCalculation((AbstractColumn)column, Price.class, DJCalculation.SUM);
        }
        return builder;
    }

    @Override
    protected String getAdditionalFooterText() {
        return "Sales in this report are being filtered based on " + ReportProviderHelper.describeRangeFilter(this.compiler.getSearcher().getDateRangeFilter()) + " by Trading Day";
    }
}

