/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.sales;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.inventory.InventoryRemovable;
import ordermate.database.inventory.ModificationSize;
import ordermate.database.sales.SalesMod;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="sales_remove")
@DiscriminatorColumn(name="type")
@AccessType(value="property")
public abstract class AbstractSalesRemove
extends SalesMod
implements SaveableChild {
    public static final Props Properties = new Props();
    private Reference<ModificationSize> modificationSize;
    private double quantity;

    public AbstractSalesRemove() {
        this.modificationSize = this.createReference(AbstractSalesRemove.Properties.MODIFICATION_SIZE);
    }

    public AbstractSalesRemove(AbstractSalesRemove copy) {
        super(copy);
        this.modificationSize = this.createReference(AbstractSalesRemove.Properties.MODIFICATION_SIZE);
        this.modificationSize.set(copy.getModificationSize());
        this.quantity = copy.quantity;
    }

    public AbstractSalesRemove(ModificationSize size) {
        this.modificationSize = this.createReference(AbstractSalesRemove.Properties.MODIFICATION_SIZE);
        if (size == null) {
            throw new IllegalArgumentException("Modification size must not be null");
        }
        this.setModificationSize(size);
    }

    @Override
    @ManyToOne
    @JoinColumn(name="FK_inventory_add_remove_type")
    public ModificationSize getModificationSize() {
        return this.modificationSize.get();
    }

    @Override
    public void setModificationSize(ModificationSize size) {
        this.modificationSize.set(size);
    }

    @Column(name="quantity")
    protected double getQuantity() {
        return this.quantity;
    }

    protected void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    @Override
    @Transient
    public int getSequence() {
        return 0;
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public abstract boolean matches(InventoryRemovable var1);

    public abstract boolean matches(AbstractSalesRemove var1);

    public abstract AbstractSalesRemove copy();

    public static class Props
    extends SalesMod.Props {
        public PropertiedObject.Property<ModificationSize> MODIFICATION_SIZE;
        public PropertiedObject.Property QUANTITY;
    }
}

